/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.entity.attribute;

import java.util.Objects;
import java.util.UUID;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import org.spongepowered.api.entity.attribute.AttributeModifier;
import org.spongepowered.api.entity.attribute.AttributeOperation;

public final class SpongeAttributeModifierBuilder
implements AttributeModifier.Builder {
    private UUID id = UUID.randomUUID();
    private String name;
    private AttributeOperation operation;
    private double amount;

    @Override
    public AttributeModifier.Builder id(UUID id) {
        this.id = Objects.requireNonNull(id, "Modifier id cannot be null");
        return this;
    }

    @Override
    public AttributeModifier.Builder name(String name) {
        this.name = Objects.requireNonNull(name, "Name cannot be null");
        return this;
    }

    @Override
    public AttributeModifier.Builder operation(AttributeOperation operation) {
        this.operation = Objects.requireNonNull(operation, "Operation cannot be null");
        return this;
    }

    @Override
    public AttributeModifier.Builder amount(double amount) {
        this.amount = amount;
        return this;
    }

    @Override
    public org.spongepowered.api.entity.attribute.AttributeModifier build() {
        Objects.requireNonNull(this.name, "Name must be set");
        Objects.requireNonNull(this.operation, "Operation must be set");
        return (org.spongepowered.api.entity.attribute.AttributeModifier)new AttributeModifier(this.id, this.name, this.amount, (AttributeModifier.Operation)this.operation);
    }

    @Override
    public AttributeModifier.Builder reset() {
        this.id = UUID.randomUUID();
        this.name = null;
        this.amount = 0.0;
        this.operation = null;
        return this;
    }
}

