/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.entity.player.tab;

import com.google.common.collect.Maps;
import com.mojang.authlib.GameProfile;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.UUID;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.RemoteChatSession;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundPlayerInfoRemovePacket;
import net.minecraft.network.protocol.game.ClientboundPlayerInfoUpdatePacket;
import net.minecraft.network.protocol.game.ClientboundTabListPacket;
import net.minecraft.world.level.GameType;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.entity.living.player.gamemode.GameMode;
import org.spongepowered.api.entity.living.player.server.ServerPlayer;
import org.spongepowered.api.entity.living.player.tab.TabList;
import org.spongepowered.api.entity.living.player.tab.TabListEntry;
import org.spongepowered.common.accessor.network.protocol.game.ClientboundPlayerInfoUpdatePacketAccessor;
import org.spongepowered.common.adventure.SpongeAdventure;
import org.spongepowered.common.entity.player.tab.SpongeTabListEntry;
import org.spongepowered.common.profile.SpongeGameProfile;
import org.spongepowered.common.util.Preconditions;

public final class SpongeTabList
implements TabList {
    private static final Component EMPTY_COMPONENT = Component.literal((String)"");
    private final net.minecraft.server.level.ServerPlayer player;
    private @Nullable net.kyori.adventure.text.Component header;
    private @Nullable net.kyori.adventure.text.Component footer;
    private final Map<UUID, TabListEntry> entries = Maps.newHashMap();

    public SpongeTabList(net.minecraft.server.level.ServerPlayer player) {
        this.player = player;
    }

    @Override
    public ServerPlayer player() {
        return (ServerPlayer)this.player;
    }

    @Override
    public Optional<net.kyori.adventure.text.Component> header() {
        return Optional.ofNullable(this.header);
    }

    @Override
    public TabList setHeader(@Nullable net.kyori.adventure.text.Component header) {
        this.header = header;
        this.refreshClientHeaderFooter();
        return this;
    }

    @Override
    public Optional<net.kyori.adventure.text.Component> footer() {
        return Optional.ofNullable(this.footer);
    }

    @Override
    public TabList setFooter(@Nullable net.kyori.adventure.text.Component footer) {
        this.footer = footer;
        this.refreshClientHeaderFooter();
        return this;
    }

    @Override
    public TabList setHeaderAndFooter(@Nullable net.kyori.adventure.text.Component header, @Nullable net.kyori.adventure.text.Component footer) {
        this.header = header;
        this.footer = footer;
        this.refreshClientHeaderFooter();
        return this;
    }

    private void refreshClientHeaderFooter() {
        ClientboundTabListPacket packet = new ClientboundTabListPacket(this.header == null ? EMPTY_COMPONENT : SpongeAdventure.asVanilla(this.header), this.footer == null ? EMPTY_COMPONENT : SpongeAdventure.asVanilla(this.footer));
        this.player.connection.send((Packet)packet);
    }

    @Override
    public Collection<TabListEntry> entries() {
        return Collections.unmodifiableCollection(this.entries.values());
    }

    @Override
    public Optional<TabListEntry> entry(UUID uniqueId) {
        Objects.requireNonNull(uniqueId, "unique id");
        return Optional.ofNullable(this.entries.get(uniqueId));
    }

    @Override
    public TabList addEntry(TabListEntry entry) throws IllegalArgumentException {
        Objects.requireNonNull(entry, "builder");
        Preconditions.checkState(entry.list().equals(this), "the provided tab list entry was not created for this tab list");
        this.addEntry(entry, true);
        return this;
    }

    private void addEntry(ClientboundPlayerInfoUpdatePacket.Entry entry) {
        GameProfile profile = entry.profile();
        if (!this.entries.containsKey(profile.getId())) {
            @Nullable Component displayName = entry.displayName();
            this.addEntry(new SpongeTabListEntry(this, SpongeGameProfile.of(profile), displayName == null ? null : SpongeAdventure.asAdventure(displayName), entry.latency(), (GameMode)entry.gameMode(), entry.listed(), entry.chatSession() == null ? null : entry.chatSession().profilePublicKey()), false);
        }
    }

    private void addEntry(TabListEntry entry, boolean exceptionOnDuplicate) {
        UUID uniqueId = entry.profile().uniqueId();
        @Nullable TabListEntry prev = this.entries.putIfAbsent(uniqueId, entry);
        if (exceptionOnDuplicate && prev != null) {
            throw new IllegalArgumentException("cannot add duplicate entry");
        }
        if (prev == null) {
            this.sendUpdate(entry, EnumSet.allOf(ClientboundPlayerInfoUpdatePacket.Action.class));
        }
    }

    @Override
    public Optional<TabListEntry> removeEntry(UUID uniqueId) {
        Objects.requireNonNull(uniqueId, "unique id");
        TabListEntry entry = this.entries.remove(uniqueId);
        if (entry != null) {
            this.player.connection.send((Packet)new ClientboundPlayerInfoRemovePacket(List.of(entry.profile().uniqueId())));
            return Optional.of(entry);
        }
        return Optional.empty();
    }

    void sendUpdate(TabListEntry entry, EnumSet<ClientboundPlayerInfoUpdatePacket.Action> actions) {
        ClientboundPlayerInfoUpdatePacket packet = new ClientboundPlayerInfoUpdatePacket(actions, List.of());
        RemoteChatSession.Data chatSessionData = ((SpongeTabListEntry)entry).profilePublicKey() == null ? null : new RemoteChatSession.Data(entry.profile().uuid(), ((SpongeTabListEntry)entry).profilePublicKey());
        Component displayName = entry.displayName().isPresent() ? SpongeAdventure.asVanilla(entry.displayName().get()) : null;
        ClientboundPlayerInfoUpdatePacket.Entry data = new ClientboundPlayerInfoUpdatePacket.Entry(entry.profile().uniqueId(), SpongeGameProfile.toMcProfile(entry.profile()), entry.listed(), entry.latency(), (GameType)entry.gameMode(), displayName, chatSessionData);
        ((ClientboundPlayerInfoUpdatePacketAccessor)packet).accessor$entries(List.of(data));
        this.player.connection.send((Packet)packet);
    }

    public void updateEntriesOnSend(ClientboundPlayerInfoUpdatePacket packet) {
        EnumSet actions = packet.actions();
        for (ClientboundPlayerInfoUpdatePacket.Entry update : packet.entries()) {
            if (actions.contains(ClientboundPlayerInfoUpdatePacket.Action.ADD_PLAYER)) {
                this.addEntry(update);
            }
            this.entry(update.profileId()).ifPresent(entry -> {
                if (actions.contains(ClientboundPlayerInfoUpdatePacket.Action.UPDATE_DISPLAY_NAME)) {
                    ((SpongeTabListEntry)entry).updateWithoutSend();
                    entry.setDisplayName(update.displayName() == null ? null : SpongeAdventure.asAdventure(update.displayName()));
                }
                if (actions.contains(ClientboundPlayerInfoUpdatePacket.Action.UPDATE_LATENCY)) {
                    ((SpongeTabListEntry)entry).updateWithoutSend();
                    entry.setLatency(update.latency());
                }
                if (actions.contains(ClientboundPlayerInfoUpdatePacket.Action.UPDATE_GAME_MODE)) {
                    ((SpongeTabListEntry)entry).updateWithoutSend();
                    entry.setGameMode((GameMode)update.gameMode());
                }
                if (actions.contains(ClientboundPlayerInfoUpdatePacket.Action.UPDATE_LISTED)) {
                    ((SpongeTabListEntry)entry).updateWithoutSend();
                    entry.setListed(update.listed());
                }
            });
        }
    }

    public String toString() {
        return new StringJoiner(", ", SpongeTabList.class.getSimpleName() + "[", "]").add("player=" + this.player).add("header=" + this.header).add("footer=" + this.footer).add("entries=" + this.entries).toString();
    }
}

