/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking.context.transaction.pipeline;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.LevelChunkSection;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.common.event.tracking.PhaseContext;
import org.spongepowered.common.event.tracking.context.transaction.EffectTransactor;
import org.spongepowered.common.event.tracking.context.transaction.ResultingTransactionBySideEffect;
import org.spongepowered.common.event.tracking.context.transaction.effect.EffectResult;
import org.spongepowered.common.event.tracking.context.transaction.effect.ProcessingSideEffect;
import org.spongepowered.common.event.tracking.context.transaction.pipeline.BlockPipeline;
import org.spongepowered.common.event.tracking.context.transaction.pipeline.ChunkPipeline;
import org.spongepowered.common.event.tracking.context.transaction.pipeline.PipelineCursor;
import org.spongepowered.common.world.SpongeBlockChangeFlag;

public final class WorldPipeline
implements BlockPipeline {
    private final Supplier<LevelChunk> chunkSupplier;
    private final Supplier<ServerLevel> serverWorld;
    private final Supplier<LevelChunkSection> sectionSupplier;
    private final boolean wasEmpty;
    private final List<ResultingTransactionBySideEffect> worldEffects;
    private final ChunkPipeline chunkPipeline;

    WorldPipeline(Builder builder) {
        this.chunkSupplier = builder.chunkSupplier;
        this.worldEffects = builder.effects;
        this.serverWorld = builder.serverWorld;
        this.sectionSupplier = builder.sectionSupplier;
        @Nullable LevelChunkSection chunkSection = Objects.requireNonNull(builder.sectionSupplier).get();
        this.wasEmpty = chunkSection == null || chunkSection.hasOnlyAir();
        this.chunkPipeline = builder.chunkPipeline;
    }

    @Override
    public ServerLevel getServerWorld() {
        return Objects.requireNonNull(this.serverWorld, "ServerWorld Supplier is null in ChunkPipeline").get();
    }

    @Override
    public LevelChunk getAffectedChunk() {
        return Objects.requireNonNull(this.chunkSupplier, "Chunk Supplier is null in ChunkPipeline").get();
    }

    @Override
    public LevelChunkSection getAffectedSection() {
        return Objects.requireNonNull(this.sectionSupplier, "ChunkSection Supplier is null in ChunkPipeline").get();
    }

    public boolean processEffects(PhaseContext<?> context, BlockState currentState, BlockState newProposedState, BlockPos pos, @Nullable Entity destroyer, SpongeBlockChangeFlag flag, int limit) {
        if (this.worldEffects.isEmpty()) {
            return false;
        }
        ServerLevel serverWorld = Objects.requireNonNull(this.serverWorld).get();
        @Nullable BlockEntity existing = this.chunkSupplier.get().getBlockEntity(pos, LevelChunk.EntityCreationType.CHECK);
        @Nullable BlockState oldState = this.chunkPipeline.processChange(context, currentState, newProposedState, pos, limit);
        if (oldState == null) {
            return false;
        }
        int oldOpacity = oldState.getLightBlock((BlockGetter)serverWorld, pos);
        PipelineCursor formerState = new PipelineCursor(oldState, oldOpacity, pos, existing, destroyer, limit);
        for (ResultingTransactionBySideEffect effect : this.worldEffects) {
            EffectTransactor ignored = context.getTransactor().pushEffect(effect);
            try {
                EffectResult result = effect.effect.processSideEffect(this, formerState, newProposedState, flag, limit);
                if (result.hasResult) {
                    boolean bl = result.resultingState != null;
                    return bl;
                }
                if (!formerState.drops.isEmpty() || result.drops.isEmpty()) continue;
                formerState = new PipelineCursor(oldState, oldOpacity, pos, existing, formerState.destroyer, result.drops, limit);
            }
            finally {
                if (ignored == null) continue;
                ignored.close();
            }
        }
        return false;
    }

    public static Builder builder(ChunkPipeline pipeline) {
        return new Builder(Objects.requireNonNull(pipeline, "ChunkPipeline cannot be null!"));
    }

    @Override
    public boolean wasEmpty() {
        return this.wasEmpty;
    }

    public static final class Builder {
        final Supplier<ServerLevel> serverWorld = chunkPipeline::getServerWorld;
        final Supplier<LevelChunk> chunkSupplier = chunkPipeline::getAffectedChunk;
        final Supplier<LevelChunkSection> sectionSupplier = chunkPipeline::getAffectedSection;
        @MonotonicNonNull List<ResultingTransactionBySideEffect> effects;
        final ChunkPipeline chunkPipeline;

        Builder(ChunkPipeline chunkPipeline) {
            this.chunkPipeline = chunkPipeline;
        }

        public Builder addEffect(ProcessingSideEffect effect) {
            if (this.effects == null) {
                this.effects = new LinkedList<ResultingTransactionBySideEffect>();
            }
            this.effects.add(new ResultingTransactionBySideEffect(Objects.requireNonNull(effect, "Effect is null")));
            return this;
        }

        public WorldPipeline build() {
            if (this.effects == null) {
                this.effects = Collections.emptyList();
            }
            return new WorldPipeline(this);
        }
    }
}

