/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking.phase.packet.player;

import net.minecraft.network.protocol.common.ServerboundResourcePackPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.network.ServerGamePacketListenerImpl;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.entity.living.player.ResourcePackStatusEvent;
import org.spongepowered.api.resourcepack.ResourcePack;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.bridge.server.network.ServerGamePacketListenerImplBridge;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.event.tracking.phase.packet.BasicPacketContext;
import org.spongepowered.common.event.tracking.phase.packet.BasicPacketState;

public final class ResourcePackState
extends BasicPacketState {
    @Override
    public void unwind(BasicPacketContext phaseContext) {
        ResourcePackStatusEvent.ResourcePackStatus status;
        ResourcePack pack;
        ServerPlayer player = phaseContext.getPacketPlayer();
        ServerGamePacketListenerImpl connection = player.connection;
        ServerGamePacketListenerImplBridge mixinHandler = (ServerGamePacketListenerImplBridge)connection;
        ServerboundResourcePackPacket resource = (ServerboundResourcePackPacket)phaseContext.getPacket();
        switch (resource.action()) {
            case ACCEPTED: {
                pack = mixinHandler.bridge$popReceivedResourcePack(true);
                status = ResourcePackStatusEvent.ResourcePackStatus.ACCEPTED;
                break;
            }
            case DECLINED: {
                pack = mixinHandler.bridge$popReceivedResourcePack(false);
                status = ResourcePackStatusEvent.ResourcePackStatus.DECLINED;
                break;
            }
            case SUCCESSFULLY_LOADED: {
                pack = mixinHandler.bridge$popAcceptedResourcePack();
                status = ResourcePackStatusEvent.ResourcePackStatus.SUCCESSFULLY_LOADED;
                break;
            }
            case FAILED_DOWNLOAD: {
                pack = mixinHandler.bridge$popAcceptedResourcePack();
                status = ResourcePackStatusEvent.ResourcePackStatus.FAILED;
                break;
            }
            case DOWNLOADED: 
            case INVALID_URL: 
            case FAILED_RELOAD: 
            case DISCARDED: {
                return;
            }
            default: {
                throw new AssertionError();
            }
        }
        if (pack == null) {
            return;
        }
        SpongeCommon.post(SpongeEventFactory.createResourcePackStatusEvent(PhaseTracker.getCauseStackManager().currentCause(), pack, (org.spongepowered.api.entity.living.player.server.ServerPlayer)player, status));
    }

    @Override
    protected boolean alwaysUnwinds() {
        return true;
    }
}

