/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking.phase.tick;

import java.lang.ref.WeakReference;
import java.util.function.BiConsumer;
import net.minecraft.server.MinecraftServer;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.common.event.tracking.IPhaseState;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.event.tracking.TrackingUtil;
import org.spongepowered.common.event.tracking.phase.tick.TickContext;
import org.spongepowered.common.event.tracking.phase.tick.TickPhaseState;

public final class ServerTickState
extends TickPhaseState<ServerTickContext> {
    private final BiConsumer<CauseStackManager.StackFrame, ServerTickContext> WORLD_MODIFIER = super.getFrameModifier().andThen((frame, context) -> {
        context.getSource(Object.class).ifPresent(frame::pushCause);
        @Nullable MinecraftServer server = (MinecraftServer)context.server.get();
        if (server != null) {
            frame.pushCause(server);
        }
    });

    @Override
    protected ServerTickContext createNewContext(PhaseTracker tracker) {
        return new ServerTickContext(this, tracker);
    }

    @Override
    public BiConsumer<CauseStackManager.StackFrame, ServerTickContext> getFrameModifier() {
        return this.WORLD_MODIFIER;
    }

    @Override
    public void unwind(ServerTickContext phaseContext) {
        TrackingUtil.processBlockCaptures(phaseContext);
    }

    public static class ServerTickContext
    extends TickContext<ServerTickContext> {
        @MonotonicNonNull WeakReference<MinecraftServer> server;

        public ServerTickContext server(MinecraftServer server) {
            this.server = new WeakReference<MinecraftServer>(server);
            return this;
        }

        ServerTickContext(IPhaseState<ServerTickContext> phaseState, PhaseTracker tracker) {
            super(phaseState, tracker);
        }
    }
}

