/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.hooks;

import com.google.common.collect.ImmutableList;
import java.util.List;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.structure.LegacyStructureDataHandler;
import net.minecraft.world.level.storage.DimensionDataStorage;

public interface WorldGenerationHooks {
    default public LegacyStructureDataHandler createLegacyStructureDataUtil(ResourceKey<Level> dimensionType, DimensionDataStorage savedData) {
        if (dimensionType == Level.OVERWORLD) {
            return new LegacyStructureDataHandler(savedData, (List)ImmutableList.of((Object)"Monument", (Object)"Stronghold", (Object)"Village", (Object)"Mineshaft", (Object)"Temple", (Object)"Mansion"), (List)ImmutableList.of((Object)"Village", (Object)"Mineshaft", (Object)"Mansion", (Object)"Igloo", (Object)"Desert_Pyramid", (Object)"Jungle_Pyramid", (Object)"Swamp_Hut", (Object)"Stronghold", (Object)"Monument"));
        }
        if (dimensionType == Level.NETHER) {
            ImmutableList keys = ImmutableList.of((Object)"Fortress");
            return new LegacyStructureDataHandler(savedData, (List)keys, (List)keys);
        }
        if (dimensionType == Level.END) {
            ImmutableList keys = ImmutableList.of((Object)"EndCity");
            return new LegacyStructureDataHandler(savedData, (List)keys, (List)keys);
        }
        throw new RuntimeException(String.format("Unknown dimension type : %s", dimensionType));
    }
}

