/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.inventory.lens.impl.slot;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.spongepowered.api.util.Tuple;
import org.spongepowered.common.inventory.adapter.impl.slots.SlotAdapter;
import org.spongepowered.common.inventory.lens.impl.slot.BasicSlotLens;
import org.spongepowered.common.inventory.lens.impl.slot.SlotLensProvider;
import org.spongepowered.common.inventory.lens.slots.SlotLens;

public class SlotLensCollection
implements SlotLensProvider {
    private final List<SlotLens> lenses;

    public SlotLensCollection(List<SlotLens> lenses) {
        this.lenses = lenses;
    }

    @Override
    public SlotLens getSlotLens(int index) {
        return this.lenses.get(index);
    }

    public static class Builder {
        private List<Tuple<Class<? extends SlotAdapter>, SlotLensProvider>> slotTypes = new ArrayList<Tuple<Class<? extends SlotAdapter>, SlotLensProvider>>();
        private final SlotLensProvider defaultProvider = i -> new BasicSlotLens(i, this.slotTypes.get(i).first());

        public Builder add() {
            return this.add(SlotAdapter.class);
        }

        public Builder add(Class<? extends SlotAdapter> type) {
            return this.add(type, this.defaultProvider);
        }

        public Builder add(Class<? extends SlotAdapter> type, SlotLensProvider provider) {
            this.slotTypes.add(Tuple.of(Objects.requireNonNull(type), provider));
            return this;
        }

        public Builder add(int count) {
            return this.add(count, SlotAdapter.class, this.defaultProvider);
        }

        public Builder add(int count, Class<? extends SlotAdapter> type) {
            return this.add(count, type, this.defaultProvider);
        }

        public Builder add(int count, Class<? extends SlotAdapter> type, SlotLensProvider provider) {
            Objects.requireNonNull(type);
            for (int i = 0; i < count; ++i) {
                this.add(type, provider);
            }
            return this;
        }

        public SlotLensCollection build() {
            ArrayList<SlotLens> lenses = new ArrayList<SlotLens>();
            for (int i = 0; i < this.slotTypes.size(); ++i) {
                lenses.add(this.slotTypes.get(i).second().getSlotLens(i));
            }
            return new SlotLensCollection(lenses);
        }

        public int size() {
            return this.slotTypes.size();
        }
    }
}

