/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.item.enchantment;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.Util;
import net.minecraft.util.RandomSource;
import net.minecraft.util.random.WeightedRandom;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.EnchantmentInstance;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.item.enchantment.Enchantment;
import org.spongepowered.api.item.enchantment.EnchantmentType;
import org.spongepowered.api.item.inventory.ItemStack;
import org.spongepowered.common.item.util.ItemStackUtil;

public final class SpongeRandomEnchantmentListBuilder
implements Enchantment.RandomListBuilder {
    private @Nullable Integer seed;
    private @Nullable Integer option;
    private @Nullable Integer level;
    private boolean treasure;
    private @Nullable List<org.spongepowered.api.item.enchantment.Enchantment> pool;
    private @Nullable ItemStack item;
    private final RandomSource randomSource = RandomSource.create();

    @Override
    public Enchantment.RandomListBuilder seed(int seed) {
        this.seed = seed;
        return this;
    }

    @Override
    public Enchantment.RandomListBuilder option(int option) {
        this.option = option;
        return this;
    }

    @Override
    public Enchantment.RandomListBuilder level(int level) {
        this.level = level;
        return this;
    }

    @Override
    public Enchantment.RandomListBuilder treasure(boolean treasure) {
        this.treasure = treasure;
        return this;
    }

    @Override
    public Enchantment.RandomListBuilder fixedPool(List<org.spongepowered.api.item.enchantment.Enchantment> pool) {
        this.pool = pool;
        return this;
    }

    @Override
    public Enchantment.RandomListBuilder item(ItemStack item) {
        this.item = item;
        return this;
    }

    @Override
    public List<org.spongepowered.api.item.enchantment.Enchantment> build() throws IllegalStateException {
        List enchantments;
        Objects.requireNonNull(this.seed, "The random seed cannot be null");
        Objects.requireNonNull(this.option, "The option cannot be null");
        Objects.requireNonNull(this.level, "The level cannot be null");
        if (this.pool == null || this.pool.isEmpty()) {
            Objects.requireNonNull(this.item, "The item cannot be null");
            this.randomSource.setSeed((long)(this.seed + this.option));
            enchantments = EnchantmentHelper.selectEnchantment((RandomSource)this.randomSource, (net.minecraft.world.item.ItemStack)ItemStackUtil.toNative(this.item), (int)this.level, (boolean)this.treasure);
        } else {
            this.randomSource.setSeed((long)(this.seed + this.option));
            enchantments = this.basedOfFixedPool(this.randomSource, this.pool);
        }
        return SpongeRandomEnchantmentListBuilder.fromNative(enchantments);
    }

    private List<EnchantmentInstance> basedOfFixedPool(RandomSource randomIn, List<org.spongepowered.api.item.enchantment.Enchantment> pool) {
        ArrayList list = Lists.newArrayList();
        List<EnchantmentInstance> list1 = SpongeRandomEnchantmentListBuilder.toNative(pool);
        if (!list1.isEmpty()) {
            WeightedRandom.getRandomItem((RandomSource)randomIn, list1).ifPresent(list::add);
            while (randomIn.nextInt(50) <= this.level) {
                EnchantmentHelper.filterCompatibleEnchantments(list1, (EnchantmentInstance)((EnchantmentInstance)Util.lastOf((List)list)));
                if (list1.isEmpty()) break;
                WeightedRandom.getRandomItem((RandomSource)randomIn, list1).ifPresent(list::add);
                this.level = this.level / 2;
            }
        }
        return list;
    }

    public static List<org.spongepowered.api.item.enchantment.Enchantment> fromNative(List<EnchantmentInstance> list) {
        return list.stream().map(data -> org.spongepowered.api.item.enchantment.Enchantment.of((EnchantmentType)data.enchantment, data.level)).collect(Collectors.toList());
    }

    public static List<EnchantmentInstance> toNative(List<org.spongepowered.api.item.enchantment.Enchantment> list) {
        return list.stream().map(ench -> new EnchantmentInstance((Enchantment)ench.type(), ench.level())).collect(Collectors.toList());
    }

    @Override
    public Enchantment.RandomListBuilder reset() {
        this.pool = null;
        this.level = null;
        this.option = null;
        this.seed = null;
        this.item = null;
        return this;
    }
}

