/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.item.recipe;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.io.IOException;
import java.util.Collection;
import java.util.function.Function;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.critereon.RecipeUnlockedTrigger;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.data.persistence.DataContainer;
import org.spongepowered.api.data.persistence.DataFormats;
import org.spongepowered.api.datapack.DataPack;
import org.spongepowered.api.item.recipe.RecipeRegistration;
import org.spongepowered.common.item.recipe.ingredient.IngredientResultUtil;
import org.spongepowered.common.item.recipe.ingredient.SpongeIngredient;

public abstract class SpongeRecipeRegistration<R extends Recipe<? extends Container>>
implements RecipeRegistration {
    private static final Gson GSON = new Gson();
    protected final ResourceLocation key;
    protected final RecipeSerializer<? extends R> serializer;
    protected final AdvancementHolder advancement;
    protected final String group;
    protected final DataPack<RecipeRegistration> pack;

    public SpongeRecipeRegistration(ResourceLocation key, String group, DataPack<RecipeRegistration> pack, RecipeCategory recipeCategory, RecipeSerializer<? extends R> serializer) {
        this.key = key;
        this.serializer = serializer;
        this.pack = pack;
        this.advancement = Advancement.Builder.advancement().addCriterion("has_the_recipe", RecipeUnlockedTrigger.unlocked((ResourceLocation)key)).rewards(AdvancementRewards.Builder.recipe((ResourceLocation)key)).build(new ResourceLocation(key.getNamespace(), "recipes/" + recipeCategory.getFolderName() + "/" + key.getPath()));
        this.group = group == null ? "" : group;
    }

    public static <R extends Recipe<C>, C extends Container> RecipeSerializer<? extends R> determineSerializer(ItemStack resultStack, Function<C, ItemStack> resultFunction, Function<CraftingContainer, NonNullList<ItemStack>> remainingItemsFunction, Collection<Ingredient> ingredients, RecipeSerializer<R> vanilla, RecipeSerializer<? extends R> sponge) {
        if (resultStack.hasTag() || resultFunction != null || remainingItemsFunction != null) {
            return sponge;
        }
        for (Ingredient value : ingredients) {
            if (!(value instanceof SpongeIngredient)) continue;
            return sponge;
        }
        return vanilla;
    }

    public static <C extends Container> boolean isVanillaSerializer(ItemStack resultStack, Function<C, ItemStack> resultFunction, Function<CraftingContainer, NonNullList<ItemStack>> remainingItemsFunction, Collection<Ingredient> ingredients) {
        if (resultStack.hasTag() || resultFunction != null || remainingItemsFunction != null) {
            return false;
        }
        for (Ingredient value : ingredients) {
            if (!(value instanceof SpongeIngredient)) continue;
            return false;
        }
        return true;
    }

    @Override
    public ResourceKey key() {
        return (ResourceKey)this.key;
    }

    @Override
    public int contentVersion() {
        return 1;
    }

    @Override
    public DataContainer toContainer() {
        JsonElement json = (JsonElement)Recipe.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)((Recipe)this.recipe())).result().get();
        try {
            return DataFormats.JSON.get().read(GSON.toJson(json));
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public DataPack<RecipeRegistration> pack() {
        return this.pack;
    }

    protected void ensureCached() {
        SpongeRecipeRegistration spongeRecipeRegistration = this;
        if (spongeRecipeRegistration instanceof ResultFunctionRegistration) {
            ResultFunctionRegistration rfr = (ResultFunctionRegistration)((Object)spongeRecipeRegistration);
            IngredientResultUtil.cacheResultFunction(this.key, rfr.resultFunction());
        }
        if ((spongeRecipeRegistration = this) instanceof RemainingItemsFunctionRegistration) {
            RemainingItemsFunctionRegistration rifr = (RemainingItemsFunctionRegistration)((Object)spongeRecipeRegistration);
            IngredientResultUtil.cacheRemainingItemsFunction(this.key, rifr.remainingItems());
        }
    }

    public AdvancementHolder advancement() {
        return this.advancement;
    }

    public static JsonObject encode(RecipeRegistration template, RegistryAccess access) {
        try {
            DataResult encoded;
            if (template instanceof SpongeRecipeRegistration) {
                SpongeRecipeRegistration srr = (SpongeRecipeRegistration)template;
                srr.ensureCached();
            }
            if ((encoded = Recipe.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)((Recipe)template.recipe()))).result().isPresent()) {
                return ((JsonElement)encoded.result().get()).getAsJsonObject();
            }
            DataResult.PartialResult error = (DataResult.PartialResult)encoded.error().get();
            throw new RuntimeException(error.message());
        }
        catch (Exception e) {
            throw new RuntimeException("Could not encode recipe " + template.key(), e);
        }
    }

    public static interface ResultFunctionRegistration<C> {
        public Function<C, ItemStack> resultFunction();
    }

    public static interface RemainingItemsFunctionRegistration<C> {
        public Function<C, NonNullList<ItemStack>> remainingItems();
    }
}

