/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.item.recipe.cooking;

import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.AbstractCookingRecipe;
import net.minecraft.world.item.crafting.BlastingRecipe;
import net.minecraft.world.item.crafting.CampfireCookingRecipe;
import net.minecraft.world.item.crafting.CookingBookCategory;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SmeltingRecipe;
import net.minecraft.world.item.crafting.SmokingRecipe;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.datapack.DataPack;
import org.spongepowered.api.item.recipe.Recipe;
import org.spongepowered.api.item.recipe.RecipeRegistration;
import org.spongepowered.api.item.recipe.cooking.CookingRecipe;
import org.spongepowered.api.util.Ticks;
import org.spongepowered.common.item.recipe.SpongeRecipeRegistration;
import org.spongepowered.common.item.recipe.cooking.SpongeBlastingRecipe;
import org.spongepowered.common.item.recipe.cooking.SpongeCampfireCookingRecipe;
import org.spongepowered.common.item.recipe.cooking.SpongeSmeltingRecipe;
import org.spongepowered.common.item.recipe.cooking.SpongeSmokingRecipe;
import org.spongepowered.common.util.SpongeTicks;

public class SpongeCookingRecipeRegistration
extends SpongeRecipeRegistration<AbstractCookingRecipe>
implements SpongeRecipeRegistration.ResultFunctionRegistration<Container> {
    private final Ingredient ingredient;
    private final float experience;
    private final Ticks cookingTime;
    private final ItemStack spongeResult;
    private final Function<Container, ItemStack> resultFunction;
    private final RecipeType<?> type;
    private final CookingBookCategory cookingCategory;

    public SpongeCookingRecipeRegistration(ResourceLocation key, RecipeType<?> type, RecipeSerializer<? extends AbstractCookingRecipe> serializer, String group, Ingredient ingredient, float experience, Ticks cookingTime, ItemStack spongeResult, Function<Container, ItemStack> resultFunction, DataPack<RecipeRegistration> pack, RecipeCategory category, CookingBookCategory cookingCategory) {
        super(key, group, pack, category, serializer);
        this.type = type;
        this.ingredient = ingredient;
        this.experience = experience;
        this.cookingTime = cookingTime;
        this.spongeResult = spongeResult;
        this.resultFunction = resultFunction;
        this.cookingCategory = cookingCategory;
    }

    public static SpongeCookingRecipeRegistration of(ResourceLocation key, RecipeType<?> type, @Nullable String group, Ingredient ingredient, Float experience, @Nullable Ticks cookingTime, ItemStack result, Function<Container, ItemStack> resultFunction, DataPack<RecipeRegistration> pack, RecipeCategory recipeCategory, CookingBookCategory cookingCategory) {
        RecipeSerializer serializer;
        Ticks finalCookingTime = cookingTime;
        if (type == RecipeType.BLASTING) {
            if (finalCookingTime == null) {
                finalCookingTime = Ticks.of(100L);
            }
            serializer = RecipeSerializer.BLASTING_RECIPE;
        } else if (type == RecipeType.CAMPFIRE_COOKING) {
            if (finalCookingTime == null) {
                finalCookingTime = Ticks.of(600L);
            }
            serializer = RecipeSerializer.CAMPFIRE_COOKING_RECIPE;
        } else if (type == RecipeType.SMOKING) {
            if (finalCookingTime == null) {
                finalCookingTime = Ticks.of(100L);
            }
            serializer = RecipeSerializer.SMOKING_RECIPE;
        } else if (type == RecipeType.SMELTING) {
            if (finalCookingTime == null) {
                finalCookingTime = Ticks.of(200L);
            }
            serializer = RecipeSerializer.SMELTING_RECIPE;
        } else {
            throw new IllegalArgumentException("Unknown RecipeType " + type);
        }
        return new SpongeCookingRecipeRegistration(key, type, (RecipeSerializer<? extends AbstractCookingRecipe>)serializer, group, ingredient, experience == null ? 0.0f : experience.floatValue(), finalCookingTime, result, resultFunction, pack, recipeCategory, cookingCategory);
    }

    @Override
    public Recipe recipe() {
        this.ensureCached();
        int ticksCookingTime = SpongeTicks.toSaturatedIntOrInfinite(this.cookingTime);
        String resultFunctionId = this.resultFunction == null ? null : this.key.toString();
        List<Ingredient> ingredientList = Collections.singletonList(this.ingredient);
        boolean isVanilla = SpongeRecipeRegistration.isVanillaSerializer(this.spongeResult, this.resultFunction, null, ingredientList);
        if (this.type == RecipeType.BLASTING) {
            if (!isVanilla) {
                return (CookingRecipe)((Object)new SpongeBlastingRecipe(this.group, this.cookingCategory, this.ingredient, this.spongeResult, this.experience, ticksCookingTime, resultFunctionId));
            }
            return (CookingRecipe)new BlastingRecipe(this.group, this.cookingCategory, this.ingredient, this.spongeResult, this.experience, ticksCookingTime);
        }
        if (this.type == RecipeType.CAMPFIRE_COOKING) {
            if (!isVanilla) {
                return (CookingRecipe)((Object)new SpongeCampfireCookingRecipe(this.group, this.cookingCategory, this.ingredient, this.spongeResult, this.experience, ticksCookingTime, resultFunctionId));
            }
            return (CookingRecipe)new CampfireCookingRecipe(this.group, this.cookingCategory, this.ingredient, this.spongeResult, this.experience, ticksCookingTime);
        }
        if (this.type == RecipeType.SMOKING) {
            if (!isVanilla) {
                return (CookingRecipe)((Object)new SpongeSmokingRecipe(this.group, this.cookingCategory, this.ingredient, this.spongeResult, this.experience, ticksCookingTime, resultFunctionId));
            }
            return (CookingRecipe)new SmokingRecipe(this.group, this.cookingCategory, this.ingredient, this.spongeResult, this.experience, ticksCookingTime);
        }
        if (this.type == RecipeType.SMELTING) {
            if (!isVanilla) {
                return (CookingRecipe)((Object)new SpongeSmeltingRecipe(this.group, this.cookingCategory, this.ingredient, this.spongeResult, this.experience, ticksCookingTime, resultFunctionId));
            }
            return (CookingRecipe)new SmeltingRecipe(this.group, this.cookingCategory, this.ingredient, this.spongeResult, this.experience, ticksCookingTime);
        }
        throw new IllegalArgumentException("Unknown RecipeType " + this.type);
    }

    @Override
    public Function<Container, ItemStack> resultFunction() {
        return this.resultFunction;
    }
}

