/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.item.recipe.smithing;

import java.util.Objects;
import java.util.function.Function;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.datapack.DataPack;
import org.spongepowered.api.datapack.DataPacks;
import org.spongepowered.api.item.ItemType;
import org.spongepowered.api.item.inventory.Inventory;
import org.spongepowered.api.item.inventory.ItemStackSnapshot;
import org.spongepowered.api.item.recipe.RecipeRegistration;
import org.spongepowered.api.item.recipe.smithing.SmithingRecipe;
import org.spongepowered.common.inventory.util.InventoryUtil;
import org.spongepowered.common.item.recipe.ingredient.IngredientUtil;
import org.spongepowered.common.item.recipe.smithing.SpongeSmithingRecipeRegistration;
import org.spongepowered.common.item.util.ItemStackUtil;
import org.spongepowered.common.util.AbstractResourceKeyedBuilder;
import org.spongepowered.common.util.Preconditions;

public final class SpongeSmithingRecipeBuilder
extends AbstractResourceKeyedBuilder<RecipeRegistration, SmithingRecipe.Builder>
implements SmithingRecipe.Builder,
SmithingRecipe.Builder.BaseStep,
SmithingRecipe.Builder.AdditionStep,
SmithingRecipe.Builder.ResultStep,
SmithingRecipe.Builder.EndStep {
    private org.spongepowered.api.item.inventory.ItemStack result;
    private Ingredient template;
    private Ingredient base;
    private Ingredient addition;
    private Function<Container, ItemStack> resultFunction;
    private @Nullable String group;
    private DataPack<RecipeRegistration> pack = DataPacks.RECIPE;
    private RecipeCategory recipeCategory = RecipeCategory.MISC;

    @Override
    public SmithingRecipe.Builder.BaseStep template(ItemType ingredient) {
        this.template = Ingredient.of((ItemLike[])new ItemLike[]{() -> (Item)ingredient});
        return this;
    }

    @Override
    public SmithingRecipe.Builder.BaseStep template(org.spongepowered.api.item.recipe.crafting.Ingredient ingredient) {
        this.template = IngredientUtil.toNative(ingredient);
        return this;
    }

    @Override
    public SmithingRecipe.Builder.AdditionStep base(ItemType ingredient) {
        this.base = Ingredient.of((ItemLike[])new ItemLike[]{() -> (Item)ingredient});
        return this;
    }

    @Override
    public SmithingRecipe.Builder.AdditionStep base(org.spongepowered.api.item.recipe.crafting.Ingredient ingredient) {
        this.base = IngredientUtil.toNative(ingredient);
        return this;
    }

    @Override
    public SmithingRecipe.Builder.ResultStep addition(ItemType ingredient) {
        this.addition = Ingredient.of((ItemLike[])new ItemLike[]{() -> (Item)ingredient});
        return this;
    }

    @Override
    public SmithingRecipe.Builder.ResultStep addition(org.spongepowered.api.item.recipe.crafting.Ingredient ingredient) {
        this.addition = IngredientUtil.toNative(ingredient);
        return this;
    }

    @Override
    public SmithingRecipe.Builder.EndStep result(ItemStackSnapshot result) {
        this.result = result.createStack();
        this.resultFunction = null;
        return this;
    }

    @Override
    public SmithingRecipe.Builder.EndStep result(org.spongepowered.api.item.inventory.ItemStack result) {
        Objects.requireNonNull(result, "result");
        this.result = result;
        this.resultFunction = null;
        return this;
    }

    @Override
    public SmithingRecipe.Builder.EndStep result(Function<Inventory, org.spongepowered.api.item.inventory.ItemStack> resultFunction, org.spongepowered.api.item.inventory.ItemStack exemplaryResult) {
        Objects.requireNonNull(exemplaryResult, "exemplaryResult");
        Preconditions.checkState(!exemplaryResult.isEmpty(), "exemplaryResult must not be empty");
        this.result = exemplaryResult;
        this.resultFunction = inv -> ItemStackUtil.toNative((org.spongepowered.api.item.inventory.ItemStack)resultFunction.apply(InventoryUtil.toInventory(inv)));
        return this;
    }

    @Override
    public SmithingRecipe.Builder.EndStep group(@Nullable String name) {
        this.group = name;
        return this;
    }

    @Override
    public SmithingRecipe.Builder.EndStep pack(DataPack<RecipeRegistration> pack) {
        this.pack = pack;
        return this;
    }

    @Override
    public RecipeRegistration build0() {
        return new SpongeSmithingRecipeRegistration((ResourceLocation)this.key, this.group, this.template, this.base, this.addition, ItemStackUtil.toNative(this.result), this.resultFunction, this.pack, this.recipeCategory);
    }

    @Override
    public SmithingRecipe.Builder reset() {
        this.result = null;
        this.resultFunction = null;
        this.base = null;
        this.addition = null;
        this.group = null;
        this.pack = DataPacks.RECIPE;
        return (SmithingRecipe.Builder)super.reset();
    }
}

