/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.item.recipe.stonecutting;

import java.util.Objects;
import java.util.function.Function;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.datapack.DataPack;
import org.spongepowered.api.datapack.DataPacks;
import org.spongepowered.api.item.ItemType;
import org.spongepowered.api.item.inventory.Inventory;
import org.spongepowered.api.item.inventory.ItemStackSnapshot;
import org.spongepowered.api.item.recipe.RecipeRegistration;
import org.spongepowered.api.item.recipe.single.StoneCutterRecipe;
import org.spongepowered.common.inventory.util.InventoryUtil;
import org.spongepowered.common.item.recipe.ingredient.IngredientUtil;
import org.spongepowered.common.item.recipe.stonecutting.SpongeStonecuttingRecipeRegistration;
import org.spongepowered.common.item.util.ItemStackUtil;
import org.spongepowered.common.util.AbstractResourceKeyedBuilder;
import org.spongepowered.common.util.Preconditions;

public final class SpongeStoneCutterRecipeBuilder
extends AbstractResourceKeyedBuilder<RecipeRegistration, StoneCutterRecipe.Builder>
implements StoneCutterRecipe.Builder,
StoneCutterRecipe.Builder.ResultStep,
StoneCutterRecipe.Builder.EndStep {
    private org.spongepowered.api.item.inventory.ItemStack result;
    private Ingredient ingredient;
    private Function<Container, ItemStack> resultFunction;
    private @Nullable String group;
    private DataPack<RecipeRegistration> pack = DataPacks.RECIPE;
    private RecipeCategory recipeCategory = RecipeCategory.MISC;

    @Override
    public StoneCutterRecipe.Builder.ResultStep ingredient(ItemType ingredient) {
        this.ingredient = Ingredient.of((ItemLike[])new ItemLike[]{() -> (Item)ingredient});
        return this;
    }

    @Override
    public StoneCutterRecipe.Builder.ResultStep ingredient(org.spongepowered.api.item.recipe.crafting.Ingredient ingredient) {
        this.ingredient = IngredientUtil.toNative(ingredient);
        return this;
    }

    @Override
    public StoneCutterRecipe.Builder.EndStep result(ItemStackSnapshot result) {
        this.result = result.createStack();
        this.resultFunction = null;
        return this;
    }

    @Override
    public StoneCutterRecipe.Builder.EndStep result(org.spongepowered.api.item.inventory.ItemStack result) {
        Objects.requireNonNull(result, "result");
        this.result = result;
        this.resultFunction = null;
        return this;
    }

    @Override
    public StoneCutterRecipe.Builder.EndStep result(Function<Inventory, org.spongepowered.api.item.inventory.ItemStack> resultFunction, org.spongepowered.api.item.inventory.ItemStack exemplaryResult) {
        Objects.requireNonNull(exemplaryResult, "exemplaryResult");
        Preconditions.checkState(!exemplaryResult.isEmpty(), "exemplaryResult must not be empty");
        this.result = exemplaryResult;
        this.resultFunction = inv -> ItemStackUtil.toNative((org.spongepowered.api.item.inventory.ItemStack)resultFunction.apply(InventoryUtil.toInventory(inv)));
        return this;
    }

    @Override
    public StoneCutterRecipe.Builder.EndStep group(@Nullable String name) {
        this.group = name;
        return this;
    }

    @Override
    public StoneCutterRecipe.Builder.EndStep pack(DataPack<RecipeRegistration> pack) {
        this.pack = pack;
        return this;
    }

    @Override
    public RecipeRegistration build0() {
        return new SpongeStonecuttingRecipeRegistration((ResourceLocation)this.key, this.group, this.ingredient, ItemStackUtil.toNative(this.result), this.resultFunction, this.pack, this.recipeCategory);
    }

    @Override
    public StoneCutterRecipe.Builder reset() {
        this.result = null;
        this.resultFunction = null;
        this.ingredient = null;
        this.group = null;
        this.pack = DataPacks.RECIPE;
        return (StoneCutterRecipe.Builder)super.reset();
    }
}

