/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.item.recipe.stonecutting;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.SingleItemRecipe;
import net.minecraft.world.item.crafting.StonecutterRecipe;
import org.spongepowered.common.bridge.world.item.crafting.RecipeResultBridge;
import org.spongepowered.common.item.recipe.ResultFunctionRecipe;
import org.spongepowered.common.item.recipe.ingredient.IngredientResultUtil;

public class SpongeStonecuttingRecipe
extends StonecutterRecipe
implements ResultFunctionRecipe {
    private static final MapCodec<ItemStack> RESULT_CODEC = RecordCodecBuilder.mapCodec($$0 -> $$0.group((App)BuiltInRegistries.ITEM.byNameCodec().fieldOf("result").forGetter(ItemStack::getItem), (App)Codec.INT.fieldOf("count").forGetter(ItemStack::getCount)).apply((Applicative)$$0, ItemStack::new));
    public static final MapCodec<SpongeStonecuttingRecipe> SPONGE_CODEC = RecordCodecBuilder.mapCodec($$1 -> $$1.group((App)Codec.STRING.fieldOf("sponge:type").forGetter(a -> "custom"), (App)ExtraCodecs.strictOptionalField((Codec)Codec.STRING, (String)"group", (Object)"").forGetter(SingleItemRecipe::getGroup), (App)Ingredient.CODEC_NONEMPTY.fieldOf("ingredient").forGetter($$0x -> (Ingredient)$$0x.getIngredients().get(0)), (App)RESULT_CODEC.forGetter($$0x -> ((RecipeResultBridge)((Object)$$0x)).bridge$result()), (App)ItemStack.CODEC.optionalFieldOf("sponge:result", (Object)ItemStack.EMPTY).forGetter($$0x -> ((RecipeResultBridge)((Object)$$0x)).bridge$spongeResult()), (App)IngredientResultUtil.CACHED_RESULT_FUNC_CODEC.optionalFieldOf("sponge:result_function").forGetter(ResultFunctionRecipe::resultFunctionId)).apply((Applicative)$$1, SpongeStonecuttingRecipe::of));
    private final String resultFunctionId;

    public static SpongeStonecuttingRecipe of(String spongeType, String groupIn, Ingredient ingredientIn, ItemStack resultIn, ItemStack spongeResult, Optional<String> resultFunctionId) {
        return new SpongeStonecuttingRecipe(groupIn, ingredientIn, spongeResult.isEmpty() ? resultIn : spongeResult, resultFunctionId.orElse(null));
    }

    public SpongeStonecuttingRecipe(String groupIn, Ingredient ingredientIn, ItemStack spongeResult, String resultFunctionId) {
        super(groupIn, ingredientIn, spongeResult);
        this.resultFunctionId = resultFunctionId;
    }

    @Override
    public Optional<String> resultFunctionId() {
        return Optional.ofNullable(this.resultFunctionId);
    }

    public ItemStack assemble(Container container, RegistryAccess $$1) {
        if (this.resultFunctionId != null) {
            return IngredientResultUtil.cachedResultFunction(this.resultFunctionId).apply(container);
        }
        return super.assemble(container, $$1);
    }

    public ItemStack getResultItem(RegistryAccess $$1) {
        return super.getResultItem($$1);
    }
}

