/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.map.color;

import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.data.persistence.DataView;
import org.spongepowered.api.data.persistence.InvalidDataException;
import org.spongepowered.api.map.color.MapColor;
import org.spongepowered.api.map.color.MapColorType;
import org.spongepowered.api.map.color.MapShade;
import org.spongepowered.api.map.color.MapShades;
import org.spongepowered.common.map.color.SpongeMapColor;
import org.spongepowered.common.util.Constants;
import org.spongepowered.common.util.MapUtil;
import org.spongepowered.common.util.Preconditions;

public final class SpongeMapColorBuilder
implements MapColor.Builder {
    private @Nullable MapColorType color = null;
    private MapShade shade = MapShades.BASE.get();

    @Override
    public MapColor.Builder shade(MapShade shade) {
        this.shade = shade;
        return this;
    }

    @Override
    public MapColor.Builder darker() {
        return this.shade(MapShades.DARKER.get());
    }

    @Override
    public MapColor.Builder darkest() {
        return this.shade(MapShades.DARKEST.get());
    }

    @Override
    public MapColor.Builder base() {
        return this.shade(MapShades.BASE.get());
    }

    @Override
    public MapColor.Builder dark() {
        return this.shade(MapShades.DARK.get());
    }

    @Override
    public MapColor.Builder baseColor(MapColorType mapColorType) {
        this.color = mapColorType;
        return this;
    }

    @Override
    public MapColor.Builder fromContainer(DataView container) {
        if (!container.contains(Constants.Map.COLOR_INDEX)) {
            return this;
        }
        this.reset();
        int colorInt = container.getInt(Constants.Map.COLOR_INDEX).get();
        this.color = MapUtil.getMapColorTypeByColorIndex(colorInt).orElseThrow(() -> new InvalidDataException("Invalid map color " + colorInt));
        container.getInt(Constants.Map.SHADE_NUM).ifPresent(mapShadeInt -> {
            this.shade = MapUtil.getMapShadeById(mapShadeInt);
        });
        return this;
    }

    @Override
    public MapColor build() throws IllegalStateException {
        Preconditions.checkState(this.color != null, "Color has not been set yet");
        return new SpongeMapColor(this.color, this.shade);
    }

    @Override
    public MapColor.Builder from(MapColor value) {
        SpongeMapColor mapColorBridge = (SpongeMapColor)value;
        this.color = mapColorBridge.type();
        this.shade = mapColorBridge.shade();
        return this;
    }

    @Override
    public MapColor.Builder reset() {
        this.color = null;
        this.shade = MapShades.BASE.get();
        return this;
    }
}

