/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.api.minecraft.server;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import net.minecraft.server.ServerScoreboard;
import net.minecraft.world.scores.Objective;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.api.scoreboard.Score;
import org.spongepowered.api.scoreboard.Scoreboard;
import org.spongepowered.api.scoreboard.Team;
import org.spongepowered.api.scoreboard.criteria.Criterion;
import org.spongepowered.api.scoreboard.displayslot.DisplaySlot;
import org.spongepowered.asm.mixin.Intrinsic;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.common.accessor.world.scores.ScoreboardAccessor;
import org.spongepowered.common.bridge.server.ServerScoreboardBridge;
import org.spongepowered.common.bridge.world.scores.ObjectiveBridge;
import org.spongepowered.common.scoreboard.SpongeObjective;

@Mixin(value={ServerScoreboard.class})
public abstract class ServerScoreboardMixin_API
implements Scoreboard {
    @Shadow
    public abstract void setDisplayObjective(net.minecraft.world.scores.DisplaySlot var1, @Nullable Objective var2);

    @Override
    public Optional<org.spongepowered.api.scoreboard.objective.Objective> objective(String name) {
        Objects.requireNonNull(name);
        Objective objective = (Objective)((ScoreboardAccessor)((Object)this)).accessor$objectivesByName().get((Object)name);
        return Optional.ofNullable(objective == null ? null : ((ObjectiveBridge)objective).bridge$getSpongeObjective());
    }

    @Override
    public Optional<org.spongepowered.api.scoreboard.objective.Objective> objective(DisplaySlot slot) {
        Objective objective = ((ScoreboardAccessor)((Object)this)).accessor$displayObjectives().get(slot);
        if (objective != null) {
            return Optional.of(((ObjectiveBridge)objective).bridge$getSpongeObjective());
        }
        return Optional.empty();
    }

    @Override
    public Set<org.spongepowered.api.scoreboard.objective.Objective> objectivesByCriterion(Criterion criterion) {
        if (((ScoreboardAccessor)((Object)this)).accessor$objectivesByCriteria().containsKey((Object)criterion)) {
            return ((List)((ScoreboardAccessor)((Object)this)).accessor$objectivesByCriteria().get((Object)criterion)).stream().map(objective -> ((ObjectiveBridge)objective).bridge$getSpongeObjective()).collect(Collectors.toSet());
        }
        return new HashSet<org.spongepowered.api.scoreboard.objective.Objective>();
    }

    @Override
    public void addObjective(org.spongepowered.api.scoreboard.objective.Objective objective) throws IllegalArgumentException {
        Objects.requireNonNull(objective);
        ((ServerScoreboardBridge)((Object)this)).bridge$addAPIObjective(objective);
    }

    @Override
    public void updateDisplaySlot(@org.checkerframework.checker.nullness.qual.Nullable org.spongepowered.api.scoreboard.objective.Objective objective, DisplaySlot displaySlot) throws IllegalStateException {
        Objects.requireNonNull(displaySlot);
        Objective mcObjective = ((net.minecraft.world.scores.Scoreboard)this).getObjective(objective.name());
        this.setDisplayObjective((net.minecraft.world.scores.DisplaySlot)displaySlot, mcObjective);
    }

    @Override
    public Set<org.spongepowered.api.scoreboard.objective.Objective> objectives() {
        return ((ScoreboardAccessor)((Object)this)).accessor$objectivesByName().values().stream().map(objective -> ((ObjectiveBridge)objective).bridge$getSpongeObjective()).collect(Collectors.toSet());
    }

    @Override
    public void removeObjective(org.spongepowered.api.scoreboard.objective.Objective objective) {
        Objects.requireNonNull(objective);
        ((ServerScoreboardBridge)((Object)this)).bridge$removeAPIObjective(objective);
    }

    @Override
    public Set<Score> scores() {
        HashSet<Score> scores = new HashSet<Score>();
        for (Objective objective : ((ScoreboardAccessor)((Object)this)).accessor$objectivesByName().values()) {
            scores.addAll(((ObjectiveBridge)objective).bridge$getSpongeObjective().scores().values());
        }
        return scores;
    }

    @Override
    public Set<Score> scores(String name) {
        Objects.requireNonNull(name);
        HashSet<Score> scores = new HashSet<Score>();
        for (Objective objective : ((ScoreboardAccessor)((Object)this)).accessor$objectivesByName().values()) {
            ((ObjectiveBridge)objective).bridge$getSpongeObjective().findScore(name).ifPresent(scores::add);
        }
        return scores;
    }

    @Override
    public void removeScores(String name) {
        Objects.requireNonNull(name);
        for (Objective objective : ((ScoreboardAccessor)((Object)this)).accessor$objectivesByName().values()) {
            SpongeObjective spongeObjective = ((ObjectiveBridge)objective).bridge$getSpongeObjective();
            spongeObjective.findScore(name).ifPresent(spongeObjective::removeScore);
        }
    }

    @Override
    @Intrinsic
    public Optional<Team> team(String name) {
        Objects.requireNonNull(name);
        return Optional.ofNullable((Team)((ScoreboardAccessor)((Object)this)).accessor$teamsByName().get((Object)name));
    }

    @Override
    public void registerTeam(Team team) throws IllegalArgumentException {
        Objects.requireNonNull(team);
        ((ServerScoreboardBridge)((Object)this)).bridge$registerTeam(team);
    }

    @Override
    public Set<Team> teams() {
        return new HashSet<Team>((Collection)((ScoreboardAccessor)((Object)this)).accessor$teamsByName().values());
    }

    @Override
    public Optional<Team> memberTeam(Component member) {
        Objects.requireNonNull(member);
        return Optional.ofNullable((Team)((ScoreboardAccessor)((Object)this)).accessor$teamsByPlayer().get((Object)LegacyComponentSerializer.legacySection().serialize(member)));
    }
}

