/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.api.minecraft.world.level.block.entity;

import java.util.Set;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.level.block.entity.BeaconBlockEntity;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.block.entity.carrier.Beacon;
import org.spongepowered.api.data.persistence.DataContainer;
import org.spongepowered.api.data.value.Value;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.common.mixin.api.minecraft.world.level.block.entity.BlockEntityMixin_API;
import org.spongepowered.common.util.Constants;

@Mixin(value={BeaconBlockEntity.class})
public abstract class BeaconBlockEntityMixin_API
extends BlockEntityMixin_API
implements Beacon {
    @Shadow
    private int levels;
    @Shadow
    private @Nullable MobEffect primaryPower;
    @Shadow
    private @Nullable MobEffect secondaryPower;

    @Override
    public int completedLevels() {
        return this.levels < 0 ? 0 : this.levels;
    }

    @Override
    public DataContainer toContainer() {
        DataContainer container = super.toContainer();
        container.set(Constants.TileEntity.Beacon.PRIMARY, BuiltInRegistries.MOB_EFFECT.getId((Object)this.primaryPower));
        container.set(Constants.TileEntity.Beacon.SECONDARY, BuiltInRegistries.MOB_EFFECT.getId((Object)this.secondaryPower));
        return container;
    }

    @Override
    protected Set<Value.Immutable<?>> api$getVanillaValues() {
        Set<Value.Immutable<?>> values = super.api$getVanillaValues();
        values.add(this.displayName().asImmutable());
        this.primaryEffect().map(Value::asImmutable).ifPresent(values::add);
        this.secondaryEffect().map(Value::asImmutable).ifPresent(values::add);
        return values;
    }
}

