/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.api.minecraft.world.level.levelgen.feature;

import com.google.gson.JsonElement;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.io.IOException;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.resources.RegistryOps;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import org.spongepowered.api.data.persistence.DataFormats;
import org.spongepowered.api.data.persistence.DataView;
import org.spongepowered.api.world.generation.feature.FeatureType;
import org.spongepowered.api.world.server.ServerLocation;
import org.spongepowered.api.world.server.ServerWorld;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.util.VecHelper;
import org.spongepowered.math.vector.Vector3i;

@Mixin(value={ConfiguredFeature.class})
public abstract class ConfiguredFeatureMixin_API<F extends Feature<FC>, FC extends FeatureConfiguration, APIF extends FeatureType>
implements org.spongepowered.api.world.generation.feature.Feature {
    @Shadow
    @Final
    private F feature;
    @Shadow
    @Final
    private FC config;

    @Shadow
    public abstract boolean shadow$place(WorldGenLevel var1, ChunkGenerator var2, RandomSource var3, BlockPos var4);

    public APIF type() {
        return (APIF)((FeatureType)this.feature);
    }

    @Override
    public DataView toContainer() {
        RegistryOps ops = RegistryOps.create((DynamicOps)JsonOps.INSTANCE, (HolderLookup.Provider)SpongeCommon.server().registryAccess());
        JsonElement serialized = (JsonElement)this.feature.configuredCodec().encodeStart((DynamicOps)ops, (Object)((ConfiguredFeature)this)).getOrThrow(false, e -> {});
        try {
            return DataFormats.JSON.get().read(serialized.toString());
        }
        catch (IOException e2) {
            throw new IllegalStateException("Could not read deserialized Feature: " + serialized, e2);
        }
    }

    @Override
    public boolean place(ServerWorld world, Vector3i pos) {
        return this.shadow$place((WorldGenLevel)world, (ChunkGenerator)world.generator(), ((WorldGenLevel)world).getRandom(), VecHelper.toBlockPos(pos));
    }

    @Override
    public boolean place(ServerLocation location) {
        return this.place((ServerWorld)location.world(), location.blockPosition());
    }
}

