/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.api.minecraft.world.level.storage;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.storage.LevelData;
import org.spongepowered.api.util.MinecraftDayTime;
import org.spongepowered.api.world.gamerule.GameRule;
import org.spongepowered.api.world.storage.WorldProperties;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.common.accessor.world.level.GameRulesAccessor;
import org.spongepowered.common.accessor.world.level.GameRules_ValueAccessor;
import org.spongepowered.common.util.SpongeMinecraftDayTime;

@Mixin(value={LevelData.class})
public interface LevelDataMixin_API
extends WorldProperties {
    @Shadow
    public long shadow$getGameTime();

    @Shadow
    public long shadow$getDayTime();

    @Shadow
    public GameRules shadow$getGameRules();

    @Override
    default public MinecraftDayTime gameTime() {
        return new SpongeMinecraftDayTime(this.shadow$getGameTime());
    }

    @Override
    default public MinecraftDayTime dayTime() {
        return new SpongeMinecraftDayTime(this.shadow$getDayTime());
    }

    @Override
    default public <V> V gameRule(GameRule<V> gameRule) {
        GameRules.Value value = this.shadow$getGameRules().getRule((GameRules.Key)Objects.requireNonNull(gameRule, "gameRule"));
        if (value instanceof GameRules.BooleanValue) {
            return (V)Boolean.valueOf(((GameRules.BooleanValue)value).get());
        }
        if (value instanceof GameRules.IntegerValue) {
            return (V)Integer.valueOf(((GameRules.IntegerValue)value).get());
        }
        return null;
    }

    @Override
    default public <V> void setGameRule(GameRule<V> gameRule, V value) {
        Objects.requireNonNull(gameRule, "gameRule");
        Objects.requireNonNull(value, "value");
        GameRules.Value mValue = this.shadow$getGameRules().getRule((GameRules.Key)gameRule);
        ((GameRules_ValueAccessor)mValue).invoker$deserialize(value.toString());
    }

    @Override
    default public Map<GameRule<?>, ?> gameRules() {
        Map<GameRules.Key<?>, GameRules.Value<?>> rules = ((GameRulesAccessor)this.shadow$getGameRules()).accessor$rules();
        HashMap<GameRule, Boolean> apiRules = new HashMap<GameRule, Boolean>();
        for (Map.Entry<GameRules.Key<?>, GameRules.Value<?>> rule : rules.entrySet()) {
            GameRule key = (GameRule)rule.getKey();
            GameRules.Value<?> mValue = rule.getValue();
            Comparable<Boolean> value = null;
            if (mValue instanceof GameRules.BooleanValue) {
                value = ((GameRules.BooleanValue)mValue).get();
            } else if (mValue instanceof GameRules.IntegerValue) {
                value = ((GameRules.IntegerValue)mValue).get();
            }
            if (value == null) continue;
            apiRules.put(key, (Boolean)value);
        }
        return apiRules;
    }
}

