/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.network.chat;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import net.kyori.adventure.text.serializer.gson.GsonComponentSerializer;
import net.minecraft.network.chat.Component;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.common.adventure.AdventureTextComponent;

@Mixin(value={Component.Serializer.class})
public abstract class Component_SerializerMixin {
    @Shadow
    @Final
    private static Gson GSON;

    @Shadow
    static JsonElement shadow$serialize(Component text) {
        throw new UnsupportedOperationException("Shadowed createLegacyDisconnectPacket");
    }

    @Inject(method={"serialize"}, at={@At(value="HEAD")}, cancellable=true)
    private static void impl$writeComponentText(Component text, CallbackInfoReturnable<JsonElement> cir) {
        if (text instanceof AdventureTextComponent) {
            AdventureTextComponent atc = (AdventureTextComponent)text;
            @Nullable Component converted = ((AdventureTextComponent)text).deepConvertedIfPresent();
            if (converted != null) {
                cir.setReturnValue((Object)Component_SerializerMixin.shadow$serialize(text));
            }
        }
    }

    @Redirect(method={"<clinit>"}, at=@At(value="INVOKE", target="com/google/gson/GsonBuilder.disableHtmlEscaping()Lcom/google/gson/GsonBuilder;", remap=false), remap=false)
    private static GsonBuilder impl$injectAdventureGson(GsonBuilder gson) {
        gson.disableHtmlEscaping();
        GsonComponentSerializer.gson().populator().apply(gson);
        return gson;
    }

    @Inject(method={"toJson"}, at={@At(value="HEAD")}, cancellable=true)
    private static void impl$redirectSerialization(Component component, CallbackInfoReturnable<String> cir) {
        if (component instanceof AdventureTextComponent) {
            AdventureTextComponent atc = (AdventureTextComponent)component;
            cir.setReturnValue((Object)GSON.toJson(atc.wrapped()));
        }
    }

    @Inject(method={"toJsonTree"}, at={@At(value="HEAD")}, cancellable=true)
    private static void impl$redirectTreeSerialization(Component component, CallbackInfoReturnable<JsonElement> cir) {
        if (component instanceof AdventureTextComponent) {
            AdventureTextComponent atc = (AdventureTextComponent)component;
            cir.setReturnValue((Object)GSON.toJsonTree(atc.wrapped()));
        }
    }
}

