/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.server.network;

import com.mojang.authlib.GameProfile;
import java.io.IOException;
import java.net.SocketAddress;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.Executor;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.configuration.ServerboundFinishConfigurationPacket;
import net.minecraft.server.network.ServerConfigurationPacketListenerImpl;
import net.minecraft.server.players.PlayerList;
import org.spongepowered.api.network.EngineConnection;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.SpongeServer;
import org.spongepowered.common.bridge.network.ConnectionBridge;
import org.spongepowered.common.bridge.server.players.PlayerListBridge;
import org.spongepowered.common.mixin.core.server.network.ServerCommonPacketListenerImplMixin;
import org.spongepowered.common.network.channel.SpongeChannelManager;

@Mixin(value={ServerConfigurationPacketListenerImpl.class})
public abstract class ServerConfigurationPacketListenerImplMixin
extends ServerCommonPacketListenerImplMixin {
    @Shadow
    @Final
    private GameProfile gameProfile;
    private boolean impl$skipBanService;

    @Shadow
    public abstract void shadow$handleConfigurationFinished(ServerboundFinishConfigurationPacket var1);

    @Inject(method={"handleConfigurationFinished"}, cancellable=true, at={@At(value="INVOKE", target="Lnet/minecraft/network/protocol/PacketUtils;ensureRunningOnSameThread(Lnet/minecraft/network/protocol/Packet;Lnet/minecraft/network/PacketListener;Lnet/minecraft/util/thread/BlockableEventLoop;)V")})
    private void impl$onHandleConfigurationFinished(ServerboundFinishConfigurationPacket $$0, CallbackInfo ci) {
        if (this.impl$skipBanService) {
            return;
        }
        ci.cancel();
        ((CompletableFuture)((CompletableFuture)((PlayerListBridge)this.server.getPlayerList()).bridge$canPlayerLogin(this.connection.getRemoteAddress(), this.gameProfile).handle((componentOpt, throwable) -> {
            if (throwable != null) {
                ((ConnectionBridge)this.connection).bridge$setKickReason((Component)Component.literal((String)"An error occurred checking ban/whitelist status."));
                SpongeCommon.logger().error("An error occurred when checking the ban/whitelist status of {}.", (Object)this.gameProfile.getId().toString());
                SpongeCommon.logger().error(throwable);
            } else if (componentOpt != null) {
                ((ConnectionBridge)this.connection).bridge$setKickReason((Component)componentOpt);
            }
            try {
                ((SpongeServer)SpongeCommon.server()).userManager().handlePlayerLogin(this.gameProfile);
            }
            catch (IOException e) {
                throw new CompletionException(e);
            }
            return null;
        })).handleAsync((ignored, throwable) -> {
            if (throwable != null) {
                if (throwable instanceof CompletionException) {
                    throw (CompletionException)throwable;
                }
                throw new CompletionException((Throwable)throwable);
            }
            ((SpongeChannelManager)SpongeCommon.game().channelManager()).sendChannelRegistrations((EngineConnection)((Object)this));
            try {
                this.impl$skipBanService = true;
                this.shadow$handleConfigurationFinished($$0);
                ((SpongeServer)SpongeCommon.server()).userManager().removeFromCache(this.gameProfile.getId());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            finally {
                this.impl$skipBanService = false;
            }
            return null;
        }, (Executor)SpongeCommon.server())).exceptionally(throwable -> {
            SpongeCommon.logger().error("Forcibly disconnecting user {} due to an error during login.", (Object)this.gameProfile, throwable);
            this.shadow$disconnect((Component)Component.literal((String)"Internal Server Error: unable to complete login."));
            return null;
        });
    }

    @Redirect(method={"handleConfigurationFinished"}, at=@At(value="INVOKE", target="Lnet/minecraft/server/players/PlayerList;canPlayerLogin(Ljava/net/SocketAddress;Lcom/mojang/authlib/GameProfile;)Lnet/minecraft/network/chat/Component;"))
    private Component impl$onCanPlayerLogin(PlayerList instance, SocketAddress $$0, GameProfile $$1) {
        return null;
    }
}

