/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.server.network;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.ParseResults;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.identity.Identified;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.minecraft.SharedConstants;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundBlockUpdatePacket;
import net.minecraft.network.protocol.game.ClientboundCommandSuggestionsPacket;
import net.minecraft.network.protocol.game.ClientboundMoveVehiclePacket;
import net.minecraft.network.protocol.game.ClientboundPlayerInfoUpdatePacket;
import net.minecraft.network.protocol.game.ServerboundCommandSuggestionPacket;
import net.minecraft.network.protocol.game.ServerboundMovePlayerPacket;
import net.minecraft.network.protocol.game.ServerboundMoveVehiclePacket;
import net.minecraft.network.protocol.game.ServerboundPlayerActionPacket;
import net.minecraft.network.protocol.game.ServerboundSwingPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayerGameMode;
import net.minecraft.server.network.FilteredText;
import net.minecraft.server.network.ServerGamePacketListenerImpl;
import net.minecraft.server.players.PlayerList;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.RelativeMovement;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.block.entity.SignBlockEntity;
import net.minecraft.world.level.block.entity.SignText;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.block.BlockSnapshot;
import org.spongepowered.api.block.entity.Sign;
import org.spongepowered.api.command.CommandCause;
import org.spongepowered.api.command.manager.CommandMapping;
import org.spongepowered.api.data.Keys;
import org.spongepowered.api.data.type.HandType;
import org.spongepowered.api.data.value.CollectionValue;
import org.spongepowered.api.data.value.ListValue;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.entity.living.Humanoid;
import org.spongepowered.api.entity.living.player.server.ServerPlayer;
import org.spongepowered.api.event.Cancellable;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.EventContextKeys;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.block.InteractBlockEvent;
import org.spongepowered.api.event.block.entity.ChangeSignEvent;
import org.spongepowered.api.event.cause.entity.MovementTypes;
import org.spongepowered.api.event.entity.living.AnimateHandEvent;
import org.spongepowered.api.event.network.ServerSideConnectionEvent;
import org.spongepowered.api.resourcepack.ResourcePack;
import org.spongepowered.api.world.server.ServerWorld;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.accessor.network.protocol.game.ServerboundMoveVehiclePacketAccessor;
import org.spongepowered.common.accessor.server.level.ServerPlayerGameModeAccessor;
import org.spongepowered.common.adventure.SpongeAdventure;
import org.spongepowered.common.bridge.server.level.ServerPlayerBridge;
import org.spongepowered.common.bridge.server.network.ServerGamePacketListenerImplBridge;
import org.spongepowered.common.command.manager.SpongeCommandManager;
import org.spongepowered.common.command.registrar.BrigadierBasedRegistrar;
import org.spongepowered.common.entity.player.tab.SpongeTabList;
import org.spongepowered.common.event.ShouldFire;
import org.spongepowered.common.event.SpongeCommonEventFactory;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.event.tracking.phase.packet.BasicPacketContext;
import org.spongepowered.common.event.tracking.phase.packet.PacketPhase;
import org.spongepowered.common.item.util.ItemStackUtil;
import org.spongepowered.common.mixin.core.server.network.ServerCommonPacketListenerImplMixin;
import org.spongepowered.common.util.CommandUtil;
import org.spongepowered.common.util.VecHelper;
import org.spongepowered.math.vector.Vector3d;

@Mixin(value={ServerGamePacketListenerImpl.class})
public abstract class ServerGamePacketListenerImplMixin
extends ServerCommonPacketListenerImplMixin
implements ServerGamePacketListenerImplBridge {
    @Shadow
    public net.minecraft.server.level.ServerPlayer player;
    @Shadow
    private double vehicleFirstGoodX;
    @Shadow
    private double vehicleFirstGoodY;
    @Shadow
    private double vehicleFirstGoodZ;
    @Shadow
    private int chatSpamTickCount;
    private @Nullable ResourcePack impl$lastAcceptedPack;
    private int impl$ignorePackets;

    @Shadow
    public abstract void shadow$teleport(double var1, double var3, double var5, float var7, float var8, Set<RelativeMovement> var9);

    @Shadow
    protected abstract CompletableFuture<List<FilteredText>> shadow$filterTextPacket(List<String> var1);

    @Shadow
    protected abstract ParseResults<CommandSourceStack> shadow$parseCommand(String var1);

    @Override
    public void impl$modifyClientBoundPacket(Packet<?> packet) {
        super.impl$modifyClientBoundPacket(packet);
        if (packet instanceof ClientboundPlayerInfoUpdatePacket) {
            ClientboundPlayerInfoUpdatePacket infoPacket = (ClientboundPlayerInfoUpdatePacket)packet;
            ((SpongeTabList)((ServerPlayer)this.player).tabList()).updateEntriesOnSend(infoPacket);
        }
    }

    @Override
    public void bridge$incrementIgnorePackets() {
        ++this.impl$ignorePackets;
    }

    @Inject(method={"handleCustomCommandSuggestions"}, at={@At(value="NEW", target="(Ljava/lang/String;)Lcom/mojang/brigadier/StringReader;", remap=false)}, cancellable=true)
    private void impl$getSuggestionsFromNonBrigCommand(ServerboundCommandSuggestionPacket packet, CallbackInfo ci) {
        String rawCommand = packet.getCommand();
        String[] command = CommandUtil.extractCommandString(rawCommand);
        CommandCause cause = CommandCause.create();
        SpongeCommandManager manager = SpongeCommandManager.get(this.server);
        if (!rawCommand.contains(" ")) {
            SuggestionsBuilder builder = new SuggestionsBuilder(command[0], 0);
            if (command[0].isEmpty()) {
                manager.getAliasesForCause(cause).forEach(arg_0 -> ((SuggestionsBuilder)builder).suggest(arg_0));
            } else {
                manager.getAliasesThatStartWithForCause(cause, command[0]).forEach(arg_0 -> ((SuggestionsBuilder)builder).suggest(arg_0));
            }
            this.connection.send((Packet)new ClientboundCommandSuggestionsPacket(packet.getId(), builder.build()));
            ci.cancel();
        } else {
            Optional<CommandMapping> mappingOptional = manager.commandMapping(command[0].toLowerCase(Locale.ROOT)).filter(x -> !(x.registrar() instanceof BrigadierBasedRegistrar));
            if (mappingOptional.isPresent()) {
                CommandMapping mapping = mappingOptional.get();
                if (mapping.registrar().canExecute(cause, mapping)) {
                    SuggestionsBuilder builder = CommandUtil.createSuggestionsForRawCommand(rawCommand, command, cause, mapping);
                    this.connection.send((Packet)new ClientboundCommandSuggestionsPacket(packet.getId(), builder.build()));
                } else {
                    this.connection.send((Packet)new ClientboundCommandSuggestionsPacket(packet.getId(), (Suggestions)Suggestions.empty().join()));
                }
                ci.cancel();
            }
        }
    }

    @Redirect(method={"handleCustomCommandSuggestions"}, at=@At(value="INVOKE", target="Lcom/mojang/brigadier/CommandDispatcher;parse(Lcom/mojang/brigadier/StringReader;Ljava/lang/Object;)Lcom/mojang/brigadier/ParseResults;", remap=false))
    private ParseResults<CommandSourceStack> impl$informParserThisIsASuggestionCheck(CommandDispatcher<CommandSourceStack> commandDispatcher, StringReader command, Object source) {
        return SpongeCommandManager.get(this.server).getDispatcher().parse(command, (CommandSourceStack)source, true);
    }

    @Inject(method={"handleMovePlayer"}, at={@At(value="INVOKE", target="Lnet/minecraft/server/level/ServerPlayer;isPassenger()Z")}, cancellable=true)
    private void impl$callMoveEntityEvent(ServerboundMovePlayerPacket packetIn, CallbackInfo ci) {
        Vector3d toRotation;
        Vector3d toPosition;
        boolean fireMoveEvent = packetIn.hasPosition();
        boolean fireRotationEvent = packetIn.hasRotation();
        if (!fireMoveEvent && !fireRotationEvent) {
            return;
        }
        ServerPlayer player = (ServerPlayer)this.player;
        Vector3d fromPosition = player.position();
        Vector3d fromRotation = player.rotation();
        Vector3d originalToPosition = new Vector3d(packetIn.getX(this.player.getX()), packetIn.getY(this.player.getY()), packetIn.getZ(this.player.getZ()));
        Vector3d originalToRotation = new Vector3d(packetIn.getXRot(this.player.getXRot()), packetIn.getYRot(this.player.getYRot()), 0.0f);
        if (fireMoveEvent) {
            try (CauseStackManager.StackFrame frame = PhaseTracker.getCauseStackManager().pushCauseFrame();){
                frame.addContext(EventContextKeys.MOVEMENT_TYPE, MovementTypes.NATURAL);
                toPosition = SpongeCommonEventFactory.callMoveEvent(player, fromPosition, originalToPosition);
            }
        } else {
            toPosition = originalToPosition;
        }
        if (fireRotationEvent) {
            toRotation = SpongeCommonEventFactory.callRotateEvent(player, fromRotation, originalToRotation);
            if (toRotation == null) {
                toRotation = fromRotation;
            }
        } else {
            toRotation = originalToRotation;
        }
        if (toPosition == null) {
            this.player.absMoveTo(fromPosition.x(), fromPosition.y(), fromPosition.z());
            this.player.setXRot((float)originalToRotation.x());
            this.player.setYRot((float)originalToRotation.y());
            this.shadow$teleport(fromPosition.x(), fromPosition.y(), fromPosition.z(), (float)toRotation.y(), (float)toRotation.x(), EnumSet.of(RelativeMovement.X_ROT, RelativeMovement.Y_ROT));
            ci.cancel();
            return;
        }
        if (!toPosition.equals((Object)originalToPosition) || !toRotation.equals((Object)originalToRotation)) {
            this.player.absMoveTo(originalToPosition.x(), originalToPosition.y(), originalToPosition.z());
            this.player.setXRot((float)originalToRotation.x());
            this.player.setYRot((float)originalToRotation.y());
            this.shadow$teleport(toPosition.x(), toPosition.y(), toPosition.z(), (float)toRotation.y(), (float)toRotation.x(), EnumSet.allOf(RelativeMovement.class));
            ci.cancel();
        }
    }

    @Inject(method={"handleMoveVehicle"}, cancellable=true, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/Entity;getControllingPassenger()Lnet/minecraft/world/entity/LivingEntity;")})
    private void impl$handleVehicleMoveEvent(ServerboundMoveVehiclePacket param0, CallbackInfo ci) {
        ServerboundMoveVehiclePacketAccessor packet = (ServerboundMoveVehiclePacketAccessor)param0;
        net.minecraft.world.entity.Entity rootVehicle = this.player.getRootVehicle();
        Vector3d fromRotation = new Vector3d(rootVehicle.getYRot(), rootVehicle.getXRot(), 0.0f);
        Vector3d fromPosition = VecHelper.toVector3d(rootVehicle.position());
        Vector3d originalToPosition = new Vector3d(param0.getX(), param0.getY(), param0.getZ());
        Vector3d originalToRotation = new Vector3d(param0.getYRot(), param0.getXRot(), 0.0f);
        @Nullable Vector3d toPosition = SpongeCommonEventFactory.callMoveEvent((Entity)rootVehicle, fromPosition, originalToPosition);
        Vector3d toRotation = SpongeCommonEventFactory.callRotateEvent((Entity)rootVehicle, fromRotation, originalToRotation);
        if (toRotation == null) {
            toRotation = fromRotation;
        }
        if (toPosition == null) {
            if (!fromRotation.equals((Object)toRotation)) {
                rootVehicle.absMoveTo(rootVehicle.getX(), rootVehicle.getY(), rootVehicle.getZ(), (float)toRotation.y(), (float)toRotation.x());
            }
            this.connection.send((Packet)new ClientboundMoveVehiclePacket(rootVehicle));
            ci.cancel();
            return;
        }
        if (!toPosition.equals((Object)originalToPosition) || !toRotation.equals((Object)originalToRotation)) {
            rootVehicle.absMoveTo(toPosition.x(), toPosition.y(), toPosition.z(), (float)toRotation.y(), (float)toRotation.x());
            this.connection.send((Packet)new ClientboundMoveVehiclePacket(rootVehicle));
            packet.accessor$x(toPosition.x());
            packet.accessor$y(toPosition.y());
            packet.accessor$z(toPosition.z());
            packet.accessor$yRot((float)toRotation.x());
            packet.accessor$xRot((float)toRotation.y());
            this.vehicleFirstGoodX = toPosition.x();
            this.vehicleFirstGoodY = toPosition.y();
            this.vehicleFirstGoodZ = toPosition.z();
        }
    }

    @Inject(method={"handleAnimate"}, at={@At(value="INVOKE", target="Lnet/minecraft/server/level/ServerPlayer;resetLastActionTime()V")}, cancellable=true)
    private void impl$throwAnimationAndInteractEvents(ServerboundSwingPacket packetIn, CallbackInfo ci) {
        if (PhaseTracker.getInstance().getPhaseContext().isEmpty()) {
            return;
        }
        InteractionHand hand = packetIn.getHand();
        if (!((ServerPlayerGameModeAccessor)this.player.gameMode).accessor$isDestroyingBlock()) {
            if (this.impl$ignorePackets > 0) {
                --this.impl$ignorePackets;
            } else if (ShouldFire.INTERACT_ITEM_EVENT_PRIMARY) {
                Vec3 startPos = this.player.getEyePosition(1.0f);
                Vec3 endPos = startPos.add(this.player.getLookAngle().scale(5.0));
                BlockHitResult result = this.player.serverLevel().clip(new ClipContext(startPos, endPos, ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, (net.minecraft.world.entity.Entity)this.player));
                if (result.getType() == HitResult.Type.MISS) {
                    ItemStack heldItem = this.player.getItemInHand(hand);
                    SpongeCommonEventFactory.callInteractItemEventPrimary((Player)this.player, heldItem, hand);
                }
            }
        }
        if (ShouldFire.ANIMATE_HAND_EVENT) {
            HandType handType = (HandType)hand;
            ItemStack heldItem = this.player.getItemInHand(hand);
            try (CauseStackManager.StackFrame frame = PhaseTracker.getCauseStackManager().pushCauseFrame();){
                frame.addContext(EventContextKeys.USED_ITEM, ItemStackUtil.snapshotOf(heldItem));
                frame.addContext(EventContextKeys.USED_HAND, handType);
                AnimateHandEvent event = SpongeEventFactory.createAnimateHandEvent(frame.currentCause(), handType, (Humanoid)this.player);
                if (SpongeCommon.post(event)) {
                    ci.cancel();
                }
            }
        }
    }

    @Inject(method={"handlePlayerAction"}, at={@At(value="INVOKE", target="Lnet/minecraft/server/level/ServerPlayer;drop(Z)Z")})
    public void impl$dropItem(ServerboundPlayerActionPacket p_147345_1_, CallbackInfo ci) {
        ++this.impl$ignorePackets;
    }

    @Redirect(method={"handlePlayerAction"}, at=@At(value="INVOKE", target="Lnet/minecraft/server/level/ServerPlayerGameMode;handleBlockBreakAction(Lnet/minecraft/core/BlockPos;Lnet/minecraft/network/protocol/game/ServerboundPlayerActionPacket$Action;Lnet/minecraft/core/Direction;II)V"))
    public void impl$callInteractBlockPrimaryEvent(ServerPlayerGameMode playerInteractionManager, BlockPos pos, ServerboundPlayerActionPacket.Action act, Direction dir, int maxBuildHeight, int sequence) {
        ServerLevel level = ((ServerPlayerGameModeAccessor)playerInteractionManager).accessor$level();
        BlockSnapshot snapshot = ((ServerWorld)level).createSnapshot(VecHelper.toVector3i(pos));
        InteractBlockEvent.Primary event = SpongeCommonEventFactory.callInteractBlockEventPrimary(act, (Player)this.player, this.player.getItemInHand(InteractionHand.MAIN_HAND), snapshot, InteractionHand.MAIN_HAND, dir);
        if (event instanceof Cancellable && ((Cancellable)((Object)event)).isCancelled()) {
            this.player.connection.send((Packet)new ClientboundBlockUpdatePacket(pos, level.getBlockState(pos)));
            this.player.connection.ackBlockChangesUpTo(sequence);
            ++this.impl$ignorePackets;
        } else {
            if (act == ServerboundPlayerActionPacket.Action.ABORT_DESTROY_BLOCK && !Objects.equals(((ServerPlayerGameModeAccessor)playerInteractionManager).accessor$destroyPos(), pos)) {
                return;
            }
            playerInteractionManager.handleBlockBreakAction(pos, act, dir, maxBuildHeight, sequence);
            if (act == ServerboundPlayerActionPacket.Action.START_DESTROY_BLOCK) {
                ++this.impl$ignorePackets;
            }
        }
    }

    @Redirect(method={"removePlayerFromWorld"}, at=@At(value="INVOKE", target="Lnet/minecraft/server/players/PlayerList;broadcastSystemMessage(Lnet/minecraft/network/chat/Component;Z)V"))
    public void impl$handlePlayerDisconnect(PlayerList instance, net.minecraft.network.chat.Component $$0, boolean $$1) {
        if (this.player.connection == null) {
            return;
        }
        ServerPlayer spongePlayer = (ServerPlayer)this.player;
        try (CauseStackManager.StackFrame frame = PhaseTracker.getCauseStackManager().pushCauseFrame();){
            frame.pushCause(this.player);
            Component message = SpongeAdventure.asAdventure($$0);
            Audience audience = Sponge.server().broadcastAudience();
            ServerSideConnectionEvent.Disconnect event = SpongeEventFactory.createServerSideConnectionEventDisconnect(PhaseTracker.getCauseStackManager().currentCause(), audience, Optional.of(audience), message, message, spongePlayer.connection(), spongePlayer);
            SpongeCommon.post(event);
            event.audience().ifPresent(a -> a.sendMessage((Identified)spongePlayer, event.message()));
        }
        ((ServerPlayerBridge)this.player).bridge$getWorldBorderListener().onPlayerDisconnect();
    }

    @Redirect(method={"handleSignUpdate"}, at=@At(value="INVOKE", target="Lnet/minecraft/server/network/ServerGamePacketListenerImpl;filterTextPacket(Ljava/util/List;)Ljava/util/concurrent/CompletableFuture;"))
    private CompletableFuture<List<FilteredText>> impl$switchToSignPhaseState(ServerGamePacketListenerImpl instance, List<String> $$0) {
        try (BasicPacketContext context = (BasicPacketContext)((BasicPacketContext)PacketPhase.General.UPDATE_SIGN.createPhaseContext(PhaseTracker.getInstance()).packetPlayer(this.player)).buildAndSwitch();){
            CompletableFuture<List<FilteredText>> completableFuture = this.shadow$filterTextPacket($$0);
            return completableFuture;
        }
    }

    @Redirect(method={"updateSignText"}, at=@At(value="INVOKE", remap=false, target="Lnet/minecraft/world/level/block/entity/SignBlockEntity;updateSignText(Lnet/minecraft/world/entity/player/Player;ZLjava/util/List;)V"))
    private void impl$callChangeSignEvent(SignBlockEntity sign, Player player, boolean isFrontText, List<FilteredText> list) {
        SignText oldText = isFrontText ? sign.getFrontText() : sign.getBackText();
        CollectionValue.Immutable originalLines = ((Sign.SignText)oldText).lines().asImmutable();
        ArrayList<TextComponent> newLines = new ArrayList<TextComponent>();
        for (FilteredText line : list) {
            newLines.add(Component.text((String)SharedConstants.filterText((String)line.filtered())));
        }
        try (CauseStackManager.StackFrame frame = PhaseTracker.getCauseStackManager().pushCauseFrame();){
            frame.pushCause(this.player);
            ListValue.Mutable<Component> newLinesValue = ListValue.mutableOf(Keys.SIGN_LINES, newLines);
            ChangeSignEvent event = SpongeEventFactory.createChangeSignEvent(PhaseTracker.getCauseStackManager().currentCause(), (ListValue.Immutable<Component>)originalLines, newLinesValue, (Sign)sign, isFrontText);
            CollectionValue toApply = SpongeCommon.post(event) ? originalLines : newLinesValue;
            this.impl$updateSignText(sign, player, isFrontText, (List)toApply.get());
        }
    }

    private void impl$updateSignText(SignBlockEntity sign, Player player, boolean isFrontText, List<Component> lines) {
        if (!sign.isWaxed() && player.getUUID().equals(sign.getPlayerWhoMayEdit()) && sign.getLevel() != null) {
            if (player.isTextFilteringEnabled()) {
                // empty if block
            }
            sign.updateText(signText -> {
                for (int i = 0; i < lines.size(); ++i) {
                    signText = signText.setMessage(i, SpongeAdventure.asVanilla((Component)lines.get(i)));
                }
                return signText;
            }, isFrontText);
            sign.setAllowedPlayerEditor(null);
            sign.getLevel().sendBlockUpdated(sign.getBlockPos(), sign.getBlockState(), sign.getBlockState(), 3);
        }
    }

    @Override
    public @Nullable ResourcePack bridge$popReceivedResourcePack(boolean markAccepted) {
        ResourcePack pack = this.impl$lastReceivedPack;
        this.impl$lastReceivedPack = null;
        if (markAccepted) {
            this.impl$lastAcceptedPack = pack;
        }
        return pack;
    }

    @Override
    public @Nullable ResourcePack bridge$popAcceptedResourcePack() {
        ResourcePack pack = this.impl$lastAcceptedPack;
        this.impl$lastAcceptedPack = null;
        return pack;
    }
}

