/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.server.network;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.mojang.authlib.GameProfile;
import java.net.SocketAddress;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import net.kyori.adventure.text.TextComponent;
import net.minecraft.DefaultUncaughtExceptionHandler;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.network.ServerLoginPacketListenerImpl;
import net.minecraft.server.players.PlayerList;
import org.slf4j.Logger;
import org.spongepowered.api.event.Cause;
import org.spongepowered.api.event.EventContext;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.network.ServerSideConnectionEvent;
import org.spongepowered.api.network.ServerSideConnection;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.adventure.SpongeAdventure;
import org.spongepowered.common.bridge.network.ConnectionHolderBridge;
import org.spongepowered.common.bridge.network.ServerLoginPacketListenerImplBridge;

@Mixin(value={ServerLoginPacketListenerImpl.class})
public abstract class ServerLoginPacketListenerImplMixin
implements ConnectionHolderBridge,
ServerLoginPacketListenerImplBridge {
    @Shadow
    @Final
    static Logger LOGGER;
    @Shadow
    @Final
    Connection connection;
    @Shadow
    GameProfile authenticatedProfile;
    @Shadow
    @Final
    MinecraftServer server;
    @Shadow
    private ServerLoginPacketListenerImpl.State state;
    private static final ExecutorService impl$EXECUTOR;
    private boolean impl$accepted = false;

    @Shadow
    public abstract void shadow$disconnect(Component var1);

    @Override
    public Connection bridge$getConnection() {
        return this.connection;
    }

    @Redirect(method={"verifyLoginAndFinishConnectionSetup"}, at=@At(value="INVOKE", target="Lnet/minecraft/server/players/PlayerList;canPlayerLogin(Ljava/net/SocketAddress;Lcom/mojang/authlib/GameProfile;)Lnet/minecraft/network/chat/Component;"))
    private Component impl$onCanPlayerLogin(PlayerList instance, SocketAddress $$0, GameProfile $$1) {
        return null;
    }

    private void impl$disconnectClient(net.kyori.adventure.text.Component disconnectMessage) {
        Component reason = SpongeAdventure.asVanilla(disconnectMessage);
        this.shadow$disconnect(reason);
    }

    @Inject(method={"startClientVerification(Lcom/mojang/authlib/GameProfile;)V"}, at={@At(value="FIELD", target="Lnet/minecraft/server/network/ServerLoginPacketListenerImpl;state:Lnet/minecraft/server/network/ServerLoginPacketListenerImpl$State;")}, cancellable=true)
    private void impl$handleAuthEventCancellation(CallbackInfo ci) {
        ci.cancel();
        if (this.server.usesAuthentication() && !this.connection.isMemoryConnection()) {
            this.bridge$fireAuthEvent();
        } else {
            this.bridge$getExecutor().submit(this::bridge$fireAuthEvent);
        }
    }

    @Override
    public ExecutorService bridge$getExecutor() {
        return impl$EXECUTOR;
    }

    @Override
    public void bridge$fireAuthEvent() {
        TextComponent disconnectMessage = net.kyori.adventure.text.Component.text((String)"You are not allowed to log in to this server.");
        Cause cause = Cause.of(EventContext.empty(), this);
        ServerSideConnectionEvent.Auth event = SpongeEventFactory.createServerSideConnectionEventAuth(cause, (net.kyori.adventure.text.Component)disconnectMessage, (net.kyori.adventure.text.Component)disconnectMessage, (ServerSideConnection)((Object)this));
        SpongeCommon.post(event);
        if (event.isCancelled()) {
            this.impl$disconnectClient(event.message());
            return;
        }
        this.state = ServerLoginPacketListenerImpl.State.NEGOTIATING;
    }

    static {
        impl$EXECUTOR = Executors.newCachedThreadPool(new ThreadFactoryBuilder().setNameFormat("Sponge-LoginThread-%d").setUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)new DefaultUncaughtExceptionHandler(LOGGER)).build());
    }
}

