/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.world.entity.ai.goal;

import java.util.Set;
import java.util.StringJoiner;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.GoalSelector;
import net.minecraft.world.entity.ai.goal.WrappedGoal;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.entity.ai.goal.GoalExecutor;
import org.spongepowered.api.entity.ai.goal.GoalExecutorType;
import org.spongepowered.api.entity.living.Agent;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.entity.ai.goal.GoalEvent;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.bridge.world.entity.EntityBridge;
import org.spongepowered.common.bridge.world.entity.ai.GoalBridge;
import org.spongepowered.common.bridge.world.entity.ai.goal.GoalSelectorBridge;
import org.spongepowered.common.event.ShouldFire;
import org.spongepowered.common.event.tracking.PhaseTracker;

@Mixin(value={GoalSelector.class})
public abstract class GoalSelectorMixin
implements GoalSelectorBridge {
    @Shadow
    @Final
    private Set<WrappedGoal> availableGoals;
    private @Nullable Mob owner;
    private @Nullable GoalExecutorType type;
    private boolean initialized;

    @Redirect(method={"addGoal"}, at=@At(value="INVOKE", target="Ljava/util/Set;add(Ljava/lang/Object;)Z", remap=false))
    private boolean onAddEntityTask(Set<WrappedGoal> goals, Object task, int priority, Goal base) {
        ((GoalBridge)base).bridge$setGoalExecutor((GoalExecutor)((Object)this));
        if (!ShouldFire.GOAL_EVENT_ADD || this.owner == null || ((EntityBridge)this.owner).bridge$isConstructing()) {
            return goals.add(new WrappedGoal(priority, base));
        }
        GoalEvent.Add event = SpongeEventFactory.createGoalEventAdd(PhaseTracker.getCauseStackManager().currentCause(), priority, priority, (Agent)this.owner, (GoalExecutor)((Object)this), (org.spongepowered.api.entity.ai.goal.Goal)base);
        SpongeCommon.post(event);
        if (event.isCancelled()) {
            ((GoalBridge)base).bridge$setGoalExecutor(null);
            return false;
        }
        return goals.add(new WrappedGoal(event.priority(), base));
    }

    @Override
    public Mob bridge$getOwner() {
        return this.owner;
    }

    @Override
    public void bridge$setOwner(Mob owner) {
        this.owner = owner;
    }

    @Override
    public GoalExecutorType bridge$getType() {
        return this.type;
    }

    @Override
    public void bridge$setType(GoalExecutorType type) {
        this.type = type;
    }

    @Overwrite
    public void removeGoal(Goal task) {
        this.availableGoals.removeIf(prioritizedGoal -> {
            if (prioritizedGoal.getGoal() == task) {
                if (ShouldFire.GOAL_EVENT_REMOVE && this.owner != null && !((EntityBridge)this.owner).bridge$isConstructing()) {
                    GoalEvent.Remove event = SpongeEventFactory.createGoalEventRemove(PhaseTracker.getCauseStackManager().currentCause(), (Agent)this.owner, (GoalExecutor)((Object)this), (org.spongepowered.api.entity.ai.goal.Goal)task, prioritizedGoal.getPriority());
                    SpongeCommon.post(event);
                    if (event.isCancelled()) {
                        return false;
                    }
                }
                if (prioritizedGoal.isRunning()) {
                    prioritizedGoal.stop();
                }
                return true;
            }
            return false;
        });
    }

    @Override
    public boolean bridge$initialized() {
        return this.initialized;
    }

    @Override
    public void bridge$setInitialized(boolean initialized) {
        this.initialized = initialized;
    }

    public String toString() {
        return new StringJoiner(", ", GoalSelectorMixin.class.getSimpleName() + "[", "]").add("owner=" + this.bridge$getOwner()).add("type=" + this.bridge$getType()).toString();
    }
}

