/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.world.item;

import java.util.Optional;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.data.DataTransactionResult;
import org.spongepowered.api.data.Key;
import org.spongepowered.api.data.value.Value;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.common.bridge.data.DataCompoundHolder;
import org.spongepowered.common.bridge.data.DataHolderProcessor;
import org.spongepowered.common.bridge.data.SpongeDataHolderBridge;
import org.spongepowered.common.data.DataUtil;
import org.spongepowered.common.data.provider.nbt.NBTDataType;
import org.spongepowered.common.data.provider.nbt.NBTDataTypes;

@Mixin(value={ItemStack.class})
public abstract class ItemStackMixin
implements SpongeDataHolderBridge,
DataCompoundHolder {
    @Shadow
    private CompoundTag tag;

    @Shadow
    public abstract void shadow$setTag(@Nullable CompoundTag var1);

    @Shadow
    public abstract @Nullable CompoundTag shadow$getTag();

    @Shadow
    public abstract boolean isEmpty();

    @Override
    public <E> Optional<E> bridge$get(Key<@NonNull ? extends Value<E>> key) {
        if (this.isEmpty()) {
            return Optional.empty();
        }
        return DataHolderProcessor.bridge$get(this, key);
    }

    @Override
    public <E> DataTransactionResult bridge$offer(Key<@NonNull ? extends Value<E>> key, E value) {
        if (this.isEmpty()) {
            return DataTransactionResult.failNoData();
        }
        return DataHolderProcessor.bridge$offer(this, key, value);
    }

    @Override
    public <E> DataTransactionResult bridge$remove(Key<@NonNull ? extends Value<E>> key) {
        if (this.isEmpty()) {
            return DataTransactionResult.failNoData();
        }
        return DataHolderProcessor.bridge$remove(this, key);
    }

    @Override
    public CompoundTag data$getCompound() {
        return this.shadow$getTag();
    }

    @Override
    public void data$setCompound(CompoundTag nbt) {
        this.shadow$setTag(nbt);
    }

    @Inject(method={"copy"}, at={@At(value="RETURN")})
    private void impl$onCopy(CallbackInfoReturnable<ItemStack> info) {
        ((SpongeDataHolderBridge)info.getReturnValue()).bridge$mergeDeserialized(this.bridge$getManipulator());
    }

    @Inject(method={"split"}, at={@At(value="RETURN")})
    private void impl$onSplit(int amount, CallbackInfoReturnable<ItemStack> info) {
        ((SpongeDataHolderBridge)info.getReturnValue()).bridge$mergeDeserialized(this.bridge$getManipulator());
    }

    @Inject(method={"<init>(Lnet/minecraft/nbt/CompoundTag;)V"}, at={@At(value="RETURN")})
    private void impl$onRead(CompoundTag compound, CallbackInfo info) {
        if (!this.isEmpty()) {
            DataUtil.syncTagToData(this);
            DataUtil.syncDataToTag(this);
        }
        if (this.tag != null && this.tag.isEmpty()) {
            this.tag = null;
        }
    }

    @Inject(method={"setTag"}, at={@At(value="RETURN")})
    private void impl$onSet(CompoundTag compound, CallbackInfo callbackInfo) {
        if (this.shadow$getTag() != compound) {
            this.bridge$clear();
        }
        if (compound != null && !compound.isEmpty()) {
            DataUtil.syncTagToData(this);
            DataUtil.syncDataToTag(this);
        }
    }

    @Override
    public NBTDataType data$getNBTDataType() {
        return NBTDataTypes.ITEMSTACK;
    }

    @Inject(method={"setEntityRepresentation"}, at={@At(value="HEAD")}, cancellable=true)
    private void impl$onSetEntityRepresentation(CallbackInfo ci) {
        if (this == ItemStack.EMPTY) {
            ci.cancel();
        }
    }
}

