/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.world.level.chunk;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.chunk.UpgradeData;
import net.minecraft.world.level.levelgen.blending.BlendingData;
import net.minecraft.world.ticks.LevelChunkTicks;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.data.DataTransactionResult;
import org.spongepowered.api.data.Key;
import org.spongepowered.api.data.value.Value;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.util.Direction;
import org.spongepowered.api.world.chunk.BlockChunk;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.common.accessor.server.level.ChunkMapAccessor;
import org.spongepowered.common.applaunch.config.core.SpongeConfigs;
import org.spongepowered.common.bridge.CreatorTrackedBridge;
import org.spongepowered.common.bridge.data.DataCompoundHolder;
import org.spongepowered.common.bridge.data.DataHolderProcessor;
import org.spongepowered.common.bridge.data.SpongeDataHolderBridge;
import org.spongepowered.common.bridge.world.level.LevelBridge;
import org.spongepowered.common.bridge.world.level.chunk.CacheKeyBridge;
import org.spongepowered.common.bridge.world.level.chunk.LevelChunkBridge;
import org.spongepowered.common.bridge.world.level.storage.PrimaryLevelDataBridge;
import org.spongepowered.common.data.holder.SpongeMutableDataHolder;
import org.spongepowered.common.entity.PlayerTracker;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.util.Constants;
import org.spongepowered.common.util.DirectionUtil;

@Mixin(value={LevelChunk.class})
public abstract class LevelChunkMixin
extends ChunkAccess
implements LevelChunkBridge,
CacheKeyBridge,
SpongeMutableDataHolder,
SpongeDataHolderBridge,
DataCompoundHolder,
BlockChunk {
    @Shadow
    @Final
    private Level level;
    @Shadow
    private boolean loaded;
    private long impl$scheduledForUnload = -1L;
    private boolean impl$persistedChunk = false;
    private boolean impl$isSpawning = false;
    private final LevelChunk[] impl$neighbors = new LevelChunk[4];
    private long impl$cacheKey;
    private Map<Integer, PlayerTracker> impl$trackedIntBlockPositions = new HashMap<Integer, PlayerTracker>();
    private Map<Short, PlayerTracker> impl$trackedShortBlockPositions = new HashMap<Short, PlayerTracker>();
    private @Nullable CompoundTag impl$compound;

    @Shadow
    public abstract @Nullable BlockEntity shadow$getBlockEntity(BlockPos var1, LevelChunk.EntityCreationType var2);

    @Shadow
    public abstract BlockState shadow$getBlockState(BlockPos var1);

    @Shadow
    public abstract void shadow$addEntity(net.minecraft.world.entity.Entity var1);

    public LevelChunkMixin(ChunkPos $$0, UpgradeData $$1, LevelHeightAccessor $$2, Registry<Biome> $$3, long $$4, LevelChunkSection[] $$5, BlendingData $$6) {
        super($$0, $$1, $$2, $$3, $$4, $$5, $$6);
    }

    @Inject(method={"<init>(Lnet/minecraft/world/level/Level;Lnet/minecraft/world/level/ChunkPos;Lnet/minecraft/world/level/chunk/UpgradeData;Lnet/minecraft/world/ticks/LevelChunkTicks;Lnet/minecraft/world/ticks/LevelChunkTicks;J[Lnet/minecraft/world/level/chunk/LevelChunkSection;Lnet/minecraft/world/level/chunk/LevelChunk$PostLoadProcessor;Lnet/minecraft/world/level/levelgen/blending/BlendingData;)V"}, at={@At(value="RETURN")})
    private void impl$onConstruct(Level $$0, ChunkPos $$1, UpgradeData $$2, LevelChunkTicks $$3, LevelChunkTicks $$4, long $$5, LevelChunkSection[] $$6, LevelChunk.PostLoadProcessor $$7, BlendingData $$8, CallbackInfo ci) {
        this.impl$cacheKey = ChunkPos.asLong((int)$$1.x, (int)$$1.z);
    }

    @Override
    public LevelChunk[] bridge$getNeighborArray() {
        return Arrays.copyOf(this.impl$neighbors, this.impl$neighbors.length);
    }

    @Override
    public void bridge$markChunkDirty() {
        this.unsaved = true;
    }

    @Override
    public boolean bridge$isQueuedForUnload() {
        return ((ChunkMapAccessor)((ServerChunkCache)this.level.getChunkSource()).chunkMap).accessor$pendingUnloads().containsKey(this.chunkPos.toLong());
    }

    @Override
    public boolean bridge$isPersistedChunk() {
        return this.impl$persistedChunk;
    }

    @Override
    public boolean bridge$isSpawning() {
        return this.impl$isSpawning;
    }

    @Override
    public void bridge$setIsSpawning(boolean spawning) {
        this.impl$isSpawning = spawning;
    }

    @Override
    public Map<Integer, PlayerTracker> bridge$getTrackedIntPlayerPositions() {
        return this.impl$trackedIntBlockPositions;
    }

    @Override
    public Map<Short, PlayerTracker> bridge$getTrackedShortPlayerPositions() {
        return this.impl$trackedShortBlockPositions;
    }

    @Override
    public void bridge$setTrackedIntPlayerPositions(Map<Integer, PlayerTracker> trackedPositions) {
        this.impl$trackedIntBlockPositions = trackedPositions;
    }

    @Override
    public void bridge$setTrackedShortPlayerPositions(Map<Short, PlayerTracker> trackedPositions) {
        this.impl$trackedShortBlockPositions = trackedPositions;
    }

    @Override
    public void bridge$addTrackedBlockPosition(Block block, BlockPos pos, UUID uuid, PlayerTracker.Type trackerType) {
        if (((LevelBridge)this.level).bridge$isFake()) {
            return;
        }
        if (!PhaseTracker.getInstance().getPhaseContext().tracksCreatorsAndNotifiers()) {
            return;
        }
        BlockEntity blockEntity = (BlockEntity)this.blockEntities.get(pos);
        if (blockEntity != null && blockEntity instanceof CreatorTrackedBridge) {
            CreatorTrackedBridge trackedBlockEntity = (CreatorTrackedBridge)blockEntity;
            if (trackerType == PlayerTracker.Type.NOTIFIER) {
                if (Objects.equals(trackedBlockEntity.tracker$getNotifierUUID().orElse(null), uuid)) {
                    return;
                }
                trackedBlockEntity.tracker$setTrackedUUID(PlayerTracker.Type.NOTIFIER, uuid);
            } else {
                if (Objects.equals(trackedBlockEntity.tracker$getCreatorUUID().orElse(null), uuid)) {
                    return;
                }
                trackedBlockEntity.tracker$setTrackedUUID(PlayerTracker.Type.CREATOR, uuid);
            }
        }
        if (trackerType == PlayerTracker.Type.CREATOR) {
            this.impl$setTrackedUUID(pos, uuid, trackerType, (pt, idx) -> {
                pt.creatorindex = idx;
                pt.notifierIndex = idx;
            });
        } else {
            this.impl$setTrackedUUID(pos, uuid, trackerType, (pt, idx) -> {
                pt.notifierIndex = idx;
            });
        }
    }

    public Optional<UUID> bridge$trackedUUID(BlockPos pos, Function<PlayerTracker, Integer> func) {
        if (((LevelBridge)this.level).bridge$isFake()) {
            return Optional.empty();
        }
        int key = Constants.Sponge.blockPosToInt(pos);
        PlayerTracker intTracker = this.impl$trackedIntBlockPositions.get(key);
        if (intTracker != null) {
            int ownerIndex = func.apply(intTracker);
            return this.impl$getValidatedUUID(key, ownerIndex);
        }
        short shortKey = Constants.Sponge.blockPosToShort(pos);
        PlayerTracker shortTracker = this.impl$trackedShortBlockPositions.get(shortKey);
        if (shortTracker != null) {
            int ownerIndex = func.apply(shortTracker);
            return this.impl$getValidatedUUID(shortKey, ownerIndex);
        }
        return Optional.empty();
    }

    @Override
    public Optional<UUID> bridge$getBlockCreatorUUID(BlockPos pos) {
        return this.bridge$trackedUUID(pos, pt -> pt.creatorindex);
    }

    @Override
    public Optional<UUID> bridge$getBlockNotifierUUID(BlockPos pos) {
        return this.bridge$trackedUUID(pos, pt -> pt.notifierIndex);
    }

    private <T> void impl$computePlayerTracker(Map<T, PlayerTracker> map, T blockPos, int index, PlayerTracker.Type type, BiConsumer<PlayerTracker, Integer> consumer) {
        PlayerTracker tracker = map.get(blockPos);
        if (tracker != null) {
            consumer.accept(tracker, index);
        } else {
            map.put(blockPos, new PlayerTracker(index, type));
        }
    }

    private void impl$setTrackedUUID(BlockPos pos, UUID uuid, PlayerTracker.Type type, BiConsumer<PlayerTracker, Integer> consumer) {
        int index;
        if (((LevelBridge)this.level).bridge$isFake()) {
            return;
        }
        PrimaryLevelDataBridge worldInfo = (PrimaryLevelDataBridge)this.level.getLevelData();
        int n = index = uuid == null ? -1 : worldInfo.bridge$getIndexForUniqueId(uuid);
        if (pos.getY() <= 255) {
            short blockPos = Constants.Sponge.blockPosToShort(pos);
            this.impl$computePlayerTracker(this.impl$trackedShortBlockPositions, blockPos, index, type, consumer);
            return;
        }
        int blockPos = Constants.Sponge.blockPosToInt(pos);
        this.impl$computePlayerTracker(this.impl$trackedIntBlockPositions, blockPos, index, type, consumer);
    }

    @Override
    public void bridge$setBlockNotifier(BlockPos pos, @Nullable UUID uuid) {
        this.impl$setTrackedUUID(pos, uuid, PlayerTracker.Type.NOTIFIER, (pt, idx) -> {
            pt.notifierIndex = idx;
        });
    }

    @Override
    public void bridge$setBlockCreator(BlockPos pos, @Nullable UUID uuid) {
        this.impl$setTrackedUUID(pos, uuid, PlayerTracker.Type.CREATOR, (pt, idx) -> {
            pt.creatorindex = idx;
        });
    }

    private Optional<UUID> impl$getValidatedUUID(int key, int ownerIndex) {
        PrimaryLevelDataBridge worldInfo = (PrimaryLevelDataBridge)this.level.getLevelData();
        UUID uuid = worldInfo.bridge$getUniqueIdForIndex(ownerIndex).orElse(null);
        if (uuid != null) {
            if (SpongeConfigs.getCommon().get().world.invalidLookupUuids.contains(uuid)) {
                if (key <= Short.MAX_VALUE) {
                    this.impl$trackedShortBlockPositions.remove((short)key);
                }
                this.impl$trackedIntBlockPositions.remove(key);
                return Optional.empty();
            }
            return Optional.of(uuid);
        }
        return Optional.empty();
    }

    @Override
    public void bridge$setNeighborChunk(int index, @Nullable LevelChunk chunk) {
        this.impl$neighbors[index] = chunk;
    }

    @Override
    public @Nullable LevelChunk bridge$getNeighborChunk(int index) {
        return this.impl$neighbors[index];
    }

    @Override
    public List<LevelChunk> bridge$getNeighbors() {
        ArrayList<LevelChunk> neighborList = new ArrayList<LevelChunk>();
        for (LevelChunk neighbor : this.impl$neighbors) {
            if (neighbor == null) continue;
            neighborList.add(neighbor);
        }
        return neighborList;
    }

    @Override
    public boolean bridge$areNeighborsLoaded() {
        for (int i = 0; i < 4; ++i) {
            if (this.impl$neighbors[i] != null) continue;
            return false;
        }
        return true;
    }

    @Override
    public void bridge$setNeighbor(Direction direction, @Nullable LevelChunk neighbor) {
        this.impl$neighbors[DirectionUtil.directionToIndex((Direction)direction)] = neighbor;
    }

    @Override
    public long bridge$getScheduledForUnload() {
        return this.impl$scheduledForUnload;
    }

    @Override
    public void bridge$setScheduledForUnload(long scheduled) {
        this.impl$scheduledForUnload = scheduled;
    }

    @Override
    public boolean bridge$isActive() {
        if (this.bridge$isPersistedChunk()) {
            return true;
        }
        return this.loaded && !this.bridge$isQueuedForUnload() && this.bridge$getScheduledForUnload() == -1L;
    }

    public String toString() {
        return new StringJoiner(", ", LevelChunkMixin.class.getSimpleName() + "[", "]").add("World=" + this.level).add("Position=" + this.chunkPos.x + ":" + this.chunkPos.z).add("super=" + super.toString()).toString();
    }

    @Override
    public long bridge$getCacheKey() {
        return this.impl$cacheKey;
    }

    @Override
    public boolean bridge$spawnEntity(Entity entity) {
        net.minecraft.world.entity.Entity mcEntity = (net.minecraft.world.entity.Entity)entity;
        BlockPos blockPos = mcEntity.blockPosition();
        if (this.chunkPos.x == blockPos.getX() >> 4 && this.chunkPos.z == blockPos.getZ() >> 4) {
            this.level.addFreshEntity(mcEntity);
            return true;
        }
        return false;
    }

    @Override
    public CompoundTag data$getCompound() {
        return this.impl$compound;
    }

    @Override
    public void data$setCompound(CompoundTag nbt) {
        this.impl$compound = nbt;
    }

    @Override
    public <E> DataTransactionResult bridge$offer(Key<@NonNull ? extends Value<E>> key, E value) {
        DataTransactionResult result = DataHolderProcessor.bridge$offer(this, key, value);
        this.unsaved = true;
        return result;
    }

    @Override
    public <E> DataTransactionResult bridge$remove(Key<@NonNull ? extends Value<E>> key) {
        DataTransactionResult result = DataHolderProcessor.bridge$remove(this, key);
        this.unsaved = true;
        return result;
    }
}

