/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.world.level.entity;

import net.minecraft.world.level.Level;
import net.minecraft.world.level.entity.EntityAccess;
import net.minecraft.world.level.entity.PersistentEntitySectionManager;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.entity.EntityType;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.entity.ConstructEntityEvent;
import org.spongepowered.api.world.server.ServerLocation;
import org.spongepowered.api.world.server.ServerWorld;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.bridge.world.entity.EntityBridge;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.math.vector.Vector3d;

@Mixin(value={PersistentEntitySectionManager.class})
public class PersistentEntitySectionManagerMixin {
    @Inject(method={"addEntity(Lnet/minecraft/world/level/entity/EntityAccess;Z)Z"}, at={@At(value="HEAD")})
    private void impl$throwEntityConstructedEvent(EntityAccess entity, boolean callCreateCallback, CallbackInfoReturnable<Boolean> cir) {
        if (!(entity instanceof EntityBridge)) {
            return;
        }
        EntityBridge bridge = (EntityBridge)entity;
        if (!bridge.bridge$isConstructing()) {
            return;
        }
        bridge.bridge$fireConstructors();
        if (!(entity instanceof net.minecraft.world.entity.Entity)) {
            return;
        }
        net.minecraft.world.entity.Entity mcEntity = (net.minecraft.world.entity.Entity)entity;
        Level level = mcEntity.level();
        if (!(level instanceof ServerWorld)) {
            return;
        }
        ServerWorld sw = (ServerWorld)level;
        Vec3 position = mcEntity.position();
        ServerLocation location = ServerLocation.of(sw, position.x(), position.y(), position.z());
        Vec2 rotationVector = mcEntity.getRotationVector();
        Vector3d rotation = new Vector3d(rotationVector.x, rotationVector.y, 0.0f);
        try (CauseStackManager.StackFrame frame = PhaseTracker.SERVER.pushCauseFrame();){
            frame.pushCause(entity);
            ConstructEntityEvent.Post construct = SpongeEventFactory.createConstructEntityEventPost(frame.currentCause(), (Entity)entity, location, rotation, (EntityType)mcEntity.getType());
            SpongeCommon.post(construct);
        }
    }
}

