/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.tracker.server.network;

import net.minecraft.network.protocol.game.ServerboundPlayerActionPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.level.ServerPlayerGameMode;
import net.minecraft.server.network.ServerGamePacketListenerImpl;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.common.bridge.server.level.ServerPlayerGameModeBridge;
import org.spongepowered.common.bridge.world.entity.PlatformEntityBridge;
import org.spongepowered.common.bridge.world.level.LevelBridge;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.event.tracking.TrackingUtil;
import org.spongepowered.common.event.tracking.phase.packet.PacketContext;
import org.spongepowered.common.event.tracking.phase.packet.PacketPhaseUtil;
import org.spongepowered.common.event.tracking.phase.tick.PlayerTickContext;
import org.spongepowered.common.event.tracking.phase.tick.TickPhase;
import org.spongepowered.common.item.util.ItemStackUtil;

@Mixin(value={ServerGamePacketListenerImpl.class})
public abstract class ServerGamePacketListenerImplMixin_Tracker {
    @Shadow
    public ServerPlayer player;

    @Redirect(method={"tick"}, at=@At(value="INVOKE", target="Lnet/minecraft/server/level/ServerPlayer;doTick()V"))
    private void tracker$wrapPlayerTickWithPhase(ServerPlayer player) {
        if (((PlatformEntityBridge)player).bridge$isFakePlayer() || ((LevelBridge)player.level()).bridge$isFake()) {
            player.doTick();
            return;
        }
        try (PlayerTickContext context = (PlayerTickContext)TickPhase.Tick.PLAYER.createPhaseContext(PhaseTracker.SERVER).source(player);){
            context.buildAndSwitch();
            PhaseTracker.LOGGER.trace(TrackingUtil.PLAYER_TICK, () -> "Wrapping Player Tick: " + player.toString());
            player.doTick();
        }
    }

    @Redirect(method={"handleUseItemOn"}, at=@At(value="INVOKE", target="Lnet/minecraft/server/level/ServerPlayerGameMode;useItemOn(Lnet/minecraft/server/level/ServerPlayer;Lnet/minecraft/world/level/Level;Lnet/minecraft/world/item/ItemStack;Lnet/minecraft/world/InteractionHand;Lnet/minecraft/world/phys/BlockHitResult;)Lnet/minecraft/world/InteractionResult;"))
    private InteractionResult tracker$checkState(ServerPlayerGameMode interactionManager, ServerPlayer playerIn, Level worldIn, ItemStack stack, InteractionHand hand, BlockHitResult rayTraceResult) {
        InteractionResult actionResult = interactionManager.useItemOn(this.player, worldIn, stack, hand, rayTraceResult);
        if (PhaseTracker.getInstance().getPhaseContext().isEmpty()) {
            return actionResult;
        }
        PacketContext context = (PacketContext)PhaseTracker.getInstance().getPhaseContext();
        ItemStack itemStack = ItemStackUtil.toNative(context.getItemUsed());
        boolean isInteractionCancelled = ((ServerPlayerGameModeBridge)this.player.gameMode).bridge$isInteractBlockRightClickCancelled();
        if (ItemStack.matches((ItemStack)itemStack, (ItemStack)this.player.getItemInHand(hand)) && isInteractionCancelled) {
            PacketPhaseUtil.handlePlayerSlotRestore(this.player, itemStack, hand);
        }
        ((ServerPlayerGameModeBridge)this.player.gameMode).bridge$setInteractBlockRightClickCancelled(false);
        return actionResult;
    }

    @Inject(method={"handlePlayerAction"}, at={@At(value="INVOKE", target="Lnet/minecraft/network/protocol/game/ServerboundPlayerActionPacket;getPos()Lnet/minecraft/core/BlockPos;")})
    private void tracker$updateLastPrimaryPacket(ServerboundPlayerActionPacket packetIn, CallbackInfo ci) {
        if (PhaseTracker.getInstance().getPhaseContext().isEmpty()) {
            return;
        }
    }
}

