/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.registry.provider;

import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.RangedAttackGoal;
import net.minecraft.world.entity.ai.goal.RunAroundLikeCrazyGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import org.spongepowered.api.entity.ai.goal.GoalType;
import org.spongepowered.api.entity.ai.goal.GoalTypes;

public final class GoalTypeProvider {
    public static final GoalTypeProvider INSTANCE = new GoalTypeProvider();
    private final Map<Class<? extends Goal>, Supplier<GoalType>> mappings = new IdentityHashMap<Class<? extends Goal>, Supplier<GoalType>>();

    GoalTypeProvider() {
        this.mappings.put(AvoidEntityGoal.class, GoalTypes.AVOID_LIVING);
        this.mappings.put(MeleeAttackGoal.class, GoalTypes.ATTACK_LIVING);
        this.mappings.put(NearestAttackableTargetGoal.class, GoalTypes.FIND_NEAREST_ATTACKABLE);
        this.mappings.put(LookAtPlayerGoal.class, GoalTypes.LOOK_AT);
        this.mappings.put(RandomLookAroundGoal.class, GoalTypes.LOOK_RANDOMLY);
        this.mappings.put(RandomStrollGoal.class, GoalTypes.RANDOM_WALKING);
        this.mappings.put(RangedAttackGoal.class, GoalTypes.RANGED_ATTACK_AGAINST_AGENT);
        this.mappings.put(RunAroundLikeCrazyGoal.class, GoalTypes.RUN_AROUND_LIKE_CRAZY);
        this.mappings.put(FloatGoal.class, GoalTypes.SWIM);
    }

    public Optional<Supplier<GoalType>> get(Class<? extends Goal> type) {
        return Optional.ofNullable(this.mappings.get(type));
    }
}

