/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.resourcepack;

import com.google.common.hash.Hasher;
import com.google.common.hash.Hashing;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Objects;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.UUID;
import net.kyori.adventure.text.Component;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.resourcepack.ResourcePack;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.resourcepack.SpongeURIResourcePack;
import org.spongepowered.common.resourcepack.SpongeWorldResourcePack;

public abstract class SpongeResourcePack
implements ResourcePack {
    private final String hash;
    private final Component prompt;
    private final String id = UUID.randomUUID().toString();
    public static final int HASH_SIZE = 40;

    public SpongeResourcePack(@Nullable String hash, Component prompt) {
        this.hash = hash;
        this.prompt = prompt;
    }

    public abstract String getUrlString();

    @Override
    public String id() {
        return this.id;
    }

    @Override
    public Optional<String> hash() {
        return Optional.of(this.hash);
    }

    @Override
    public Component prompt() {
        return this.prompt;
    }

    public String toString() {
        return new StringJoiner(", ", SpongeResourcePack.class.getSimpleName() + "[", "]").add("id=" + this.id()).add("uri=" + this.uri()).toString();
    }

    public static SpongeResourcePack create(String uri, String hash, Component component) throws URISyntaxException {
        if (uri.startsWith("level://")) {
            return new SpongeWorldResourcePack(uri, hash, component);
        }
        if (hash != null && hash.length() != 40) {
            hash = null;
        }
        return new SpongeURIResourcePack(uri, hash, component);
    }

    public static SpongeResourcePack create(URI uri, String hash, Component component) {
        if (uri.toString().startsWith("level://")) {
            return new SpongeWorldResourcePack(uri, hash, component);
        }
        return new SpongeURIResourcePack(uri, hash, component);
    }

    public static final class Factory
    implements ResourcePack.Factory {
        @Override
        public ResourcePack fromUri(URI uri) throws FileNotFoundException {
            Objects.requireNonNull(uri);
            try {
                Hasher hasher = Hashing.sha1().newHasher();
                try (InputStream in = Factory.openStream(uri);){
                    int read;
                    byte[] buf = new byte[256];
                    while ((read = in.read(buf)) > 0) {
                        hasher.putBytes(buf, 0, read);
                    }
                }
                return SpongeResourcePack.create(uri, hasher.hash().toString(), (Component)Component.empty());
            }
            catch (IOException e) {
                FileNotFoundException ex = new FileNotFoundException(e.toString());
                ex.initCause(e);
                throw ex;
            }
        }

        private static InputStream openStream(URI uri) throws IOException {
            if (uri.toString().startsWith("level://")) {
                return Files.newInputStream(SpongeCommon.gameDirectory().resolve(uri.toString().substring("level://".length())), new OpenOption[0]);
            }
            return uri.toURL().openStream();
        }

        @Override
        public ResourcePack fromUriUnchecked(URI uri) {
            return SpongeResourcePack.create(Objects.requireNonNull(uri), null, (Component)Component.empty());
        }
    }
}

