/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.service.server.ban;

import com.mojang.authlib.GameProfile;
import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import net.minecraft.server.players.UserBanList;
import net.minecraft.server.players.UserBanListEntry;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.service.ban.Ban;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.bridge.server.MinecraftServerBridge;
import org.spongepowered.common.profile.SpongeGameProfile;

public class SpongeUserBanList
extends UserBanList {
    public SpongeUserBanList(File file) {
        super(file);
    }

    protected boolean contains(GameProfile profile) {
        return Sponge.server().serviceProvider().banService().find(SpongeGameProfile.of(profile)).join().isPresent();
    }

    public UserBanListEntry get(GameProfile profile) {
        Optional<Ban.Profile> ban = Sponge.server().serviceProvider().banService().find(SpongeGameProfile.of(profile)).join();
        return ban.map(x -> {
            if (x instanceof UserBanListEntry) {
                return (UserBanListEntry)x;
            }
            LegacyComponentSerializer lcs = LegacyComponentSerializer.legacySection();
            return new UserBanListEntry(SpongeGameProfile.toMcProfile(x.profile()), Date.from(x.creationDate()), (String)x.banSource().map(arg_0 -> ((LegacyComponentSerializer)lcs).serialize(arg_0)).orElse(null), (Date)x.expirationDate().map(Date::from).orElse(null), (String)x.reason().map(arg_0 -> ((LegacyComponentSerializer)lcs).serialize(arg_0)).orElse(null));
        }).orElse(null);
    }

    public String[] getUserList() {
        ArrayList names = new ArrayList();
        for (Ban.Profile ban : Sponge.server().serviceProvider().banService().profileBans().join()) {
            ban.profile().name().ifPresent(names::add);
        }
        return names.toArray(new String[names.size()]);
    }

    public void add(UserBanListEntry entry) {
        CompletableFuture<Optional<? extends Ban>> completableFuture = Sponge.server().serviceProvider().banService().add((Ban)entry);
        ((MinecraftServerBridge)SpongeCommon.server()).bridge$spongeMainThreadExecutor().managedBlock(completableFuture::isDone);
    }

    public boolean isEmpty() {
        return Sponge.server().serviceProvider().banService().profileBans().join().isEmpty();
    }

    public void remove(GameProfile entry) {
        CompletableFuture<Boolean> completableFuture = Sponge.server().serviceProvider().banService().pardon(SpongeGameProfile.of(entry));
        ((MinecraftServerBridge)SpongeCommon.server()).bridge$spongeMainThreadExecutor().managedBlock(completableFuture::isDone);
    }
}

