/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.service.server.permission;

import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import org.spongepowered.api.event.Cause;
import org.spongepowered.api.service.permission.PermissionService;
import org.spongepowered.api.service.permission.Subject;
import org.spongepowered.api.service.permission.SubjectCollection;
import org.spongepowered.api.util.Tristate;
import org.spongepowered.common.service.server.permission.MemorySubjectData;
import org.spongepowered.common.service.server.permission.SpongePermissionService;
import org.spongepowered.common.service.server.permission.SpongeSubject;
import org.spongepowered.common.service.server.permission.SpongeSubjectCollection;

public class DataFactoryCollection
extends SpongeSubjectCollection {
    private final SpongePermissionService service;
    private final ConcurrentMap<String, SpongeSubject> subjects = new ConcurrentHashMap<String, SpongeSubject>();
    private final Function<Subject, MemorySubjectData> dataFactory;

    protected DataFactoryCollection(String identifier, SpongePermissionService service, Function<Subject, MemorySubjectData> dataFactory) {
        super(identifier, service);
        this.service = service;
        this.dataFactory = dataFactory;
    }

    @Override
    public SpongeSubject get(String identifier) {
        Objects.requireNonNull(identifier, "identifier");
        if (!this.subjects.containsKey(identifier)) {
            this.subjects.putIfAbsent(identifier, new DataFactorySubject(identifier, this.dataFactory));
        }
        return (SpongeSubject)this.subjects.get(identifier);
    }

    @Override
    public boolean isRegistered(String identifier) {
        return this.subjects.containsKey(identifier);
    }

    public Collection<Subject> loadedSubjects() {
        return this.subjects.values();
    }

    private class DataFactorySubject
    extends SpongeSubject {
        private final String identifier;
        private final MemorySubjectData data;

        protected DataFactorySubject(String identifier, Function<Subject, MemorySubjectData> dataFactory) {
            this.identifier = identifier;
            this.data = dataFactory.apply(this);
        }

        @Override
        public String identifier() {
            return this.identifier;
        }

        @Override
        public Optional<String> friendlyIdentifier() {
            return Optional.empty();
        }

        @Override
        public SubjectCollection containingCollection() {
            return DataFactoryCollection.this;
        }

        @Override
        public PermissionService service() {
            return DataFactoryCollection.this.service;
        }

        @Override
        public MemorySubjectData subjectData() {
            return this.data;
        }

        @Override
        public Tristate permissionValue(String permission, Cause cause) {
            Tristate ret = super.permissionValue(permission, cause);
            if (ret == Tristate.UNDEFINED) {
                ret = this.dataPermissionValue(DataFactoryCollection.this.defaults().transientSubjectData(), permission);
            }
            if (ret == Tristate.UNDEFINED) {
                ret = this.dataPermissionValue(DataFactoryCollection.this.service.defaults().transientSubjectData(), permission);
            }
            return ret;
        }

        @Override
        public Optional<String> option(String option, Cause cause) {
            Optional<String> ret = super.option(option, cause);
            if (!ret.isPresent()) {
                ret = this.dataOptionValue(DataFactoryCollection.this.defaults().subjectData(), option);
            }
            if (!ret.isPresent()) {
                ret = this.dataOptionValue(DataFactoryCollection.this.service.defaults().subjectData(), option);
            }
            return ret;
        }
    }
}

