/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.service.server.permission;

import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.event.Cause;
import org.spongepowered.api.service.context.Context;
import org.spongepowered.api.service.permission.PermissionService;
import org.spongepowered.api.service.permission.Subject;
import org.spongepowered.api.service.permission.SubjectData;
import org.spongepowered.api.service.permission.SubjectReference;
import org.spongepowered.api.util.Tristate;
import org.spongepowered.common.service.server.permission.MemorySubjectData;

public abstract class SpongeBaseSubject
implements Subject {
    public abstract PermissionService service();

    @Override
    public abstract MemorySubjectData transientSubjectData();

    @Override
    public boolean isSubjectDataPersisted() {
        return false;
    }

    @Override
    public Optional<?> associatedObject() {
        return Optional.empty();
    }

    @Override
    public SubjectReference asSubjectReference() {
        return this.service().newSubjectReference(this.containingCollection().identifier(), this.identifier());
    }

    @Override
    public boolean hasPermission(String permission, Cause cause) {
        return this.permissionValue(permission, cause) == Tristate.TRUE;
    }

    @Override
    public boolean hasPermission(String permission, Set<Context> contexts) {
        return this.permissionValue(permission, contexts) == Tristate.TRUE;
    }

    @Override
    public Tristate permissionValue(String permission, @Nullable Cause cause) {
        return this.dataPermissionValue(this.transientSubjectData(), permission);
    }

    @Override
    public final Tristate permissionValue(String permission, Set<Context> contexts) {
        return this.permissionValue(permission, (Cause)null);
    }

    protected Tristate dataPermissionValue(MemorySubjectData subject, String permission) {
        Tristate res = subject.nodeTree(SubjectData.GLOBAL_CONTEXT).get(permission);
        if (res == Tristate.UNDEFINED) {
            for (SubjectReference parent : subject.parents(SubjectData.GLOBAL_CONTEXT)) {
                res = parent.resolve().join().permissionValue(permission, (Cause)null);
                if (res == Tristate.UNDEFINED) continue;
                return res;
            }
        }
        return res;
    }

    @Override
    public boolean isChildOf(SubjectReference parent, @Nullable Cause cause) {
        return this.subjectData().parents(SubjectData.GLOBAL_CONTEXT).contains(parent);
    }

    @Override
    public final boolean isChildOf(SubjectReference parent, Set<Context> contexts) {
        return this.isChildOf(parent, (Cause)null);
    }

    @Override
    public List<? extends SubjectReference> parents(Cause cause) {
        return this.subjectData().parents(SubjectData.GLOBAL_CONTEXT);
    }

    @Override
    public final List<? extends SubjectReference> parents(Set<Context> contexts) {
        return this.parents((Cause)null);
    }

    protected Optional<String> dataOptionValue(MemorySubjectData subject, String option) {
        Optional<String> res = Optional.ofNullable(subject.options(SubjectData.GLOBAL_CONTEXT).get(option));
        if (!res.isPresent()) {
            for (SubjectReference parent : subject.parents(SubjectData.GLOBAL_CONTEXT)) {
                res = parent.resolve().join().option(option, (Cause)null);
                if (!res.isPresent()) continue;
                return res;
            }
        }
        return res;
    }

    @Override
    public Optional<String> option(String key, @Nullable Cause cause) {
        return this.dataOptionValue(this.transientSubjectData(), key);
    }

    @Override
    public final Optional<String> option(String key, Set<Context> contexts) {
        return this.option(key, (Cause)null);
    }
}

