/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.world.generation;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.util.Objects;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.biome.MultiNoiseBiomeSource;
import net.minecraft.world.level.biome.MultiNoiseBiomeSourceParameterLists;
import net.minecraft.world.level.biome.TheEndBiomeSource;
import net.minecraft.world.level.levelgen.FlatLevelSource;
import net.minecraft.world.level.levelgen.NoiseBasedChunkGenerator;
import net.minecraft.world.level.levelgen.NoiseGeneratorSettings;
import net.minecraft.world.level.levelgen.flat.FlatLevelGeneratorSettings;
import org.spongepowered.api.data.persistence.DataFormats;
import org.spongepowered.api.data.persistence.DataView;
import org.spongepowered.api.world.biome.provider.BiomeProvider;
import org.spongepowered.api.world.generation.ChunkGenerator;
import org.spongepowered.api.world.generation.ConfigurableChunkGenerator;
import org.spongepowered.api.world.generation.config.flat.FlatGeneratorConfig;
import org.spongepowered.api.world.generation.config.noise.NoiseGeneratorConfig;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.world.server.SpongeWorldTemplate;

public final class SpongeChunkGeneratorFactory
implements ChunkGenerator.Factory {
    @Override
    public ConfigurableChunkGenerator<FlatGeneratorConfig> flat(FlatGeneratorConfig config) {
        return (ConfigurableChunkGenerator)new FlatLevelSource((FlatLevelGeneratorSettings)config);
    }

    private ConfigurableChunkGenerator<NoiseGeneratorConfig> noiseBasedChunkGenerator(BiomeSource biomeSource, Holder<NoiseGeneratorSettings> noiseGeneratorSettings) {
        return (ConfigurableChunkGenerator)new NoiseBasedChunkGenerator(biomeSource, noiseGeneratorSettings);
    }

    @Override
    public ConfigurableChunkGenerator<NoiseGeneratorConfig> noise(BiomeProvider provider, NoiseGeneratorConfig config) {
        BiomeSource biomeSource = (BiomeSource)Objects.requireNonNull(provider, "provider");
        NoiseGeneratorSettings noiseGeneratorSettings = (NoiseGeneratorSettings)Objects.requireNonNull(config, "config");
        return this.noiseBasedChunkGenerator(biomeSource, (Holder<NoiseGeneratorSettings>)Holder.direct((Object)noiseGeneratorSettings));
    }

    @Override
    public ConfigurableChunkGenerator<NoiseGeneratorConfig> overworld() {
        Registry noiseGeneratorSettingsRegistry = SpongeCommon.vanillaRegistry(Registries.NOISE_SETTINGS);
        Registry registry = SpongeCommon.vanillaRegistry(Registries.MULTI_NOISE_BIOME_SOURCE_PARAMETER_LIST);
        Holder.Reference holder = registry.getHolderOrThrow(MultiNoiseBiomeSourceParameterLists.OVERWORLD);
        MultiNoiseBiomeSource biomeSource = MultiNoiseBiomeSource.createFromPreset((Holder)holder);
        return this.noiseBasedChunkGenerator((BiomeSource)biomeSource, (Holder<NoiseGeneratorSettings>)noiseGeneratorSettingsRegistry.getHolderOrThrow(NoiseGeneratorSettings.OVERWORLD));
    }

    @Override
    public ConfigurableChunkGenerator<NoiseGeneratorConfig> theNether() {
        Registry noiseGeneratorSettingsRegistry = SpongeCommon.vanillaRegistry(Registries.NOISE_SETTINGS);
        Registry registry = SpongeCommon.vanillaRegistry(Registries.MULTI_NOISE_BIOME_SOURCE_PARAMETER_LIST);
        Holder.Reference holder = registry.getHolderOrThrow(MultiNoiseBiomeSourceParameterLists.NETHER);
        MultiNoiseBiomeSource biomeSource = MultiNoiseBiomeSource.createFromPreset((Holder)holder);
        return this.noiseBasedChunkGenerator((BiomeSource)biomeSource, (Holder<NoiseGeneratorSettings>)noiseGeneratorSettingsRegistry.getHolderOrThrow(NoiseGeneratorSettings.NETHER));
    }

    @Override
    public ConfigurableChunkGenerator<NoiseGeneratorConfig> theEnd() {
        Registry biomeRegistry = SpongeCommon.vanillaRegistry(Registries.BIOME);
        Registry noiseGeneratorSettingsRegistry = SpongeCommon.vanillaRegistry(Registries.NOISE_SETTINGS);
        TheEndBiomeSource biomeSource = TheEndBiomeSource.create((HolderGetter)biomeRegistry.asLookup());
        return this.noiseBasedChunkGenerator((BiomeSource)biomeSource, (Holder<NoiseGeneratorSettings>)noiseGeneratorSettingsRegistry.getHolderOrThrow(NoiseGeneratorSettings.END));
    }

    @Override
    public ChunkGenerator fromDataPack(DataView pack) throws IOException {
        JsonElement json = JsonParser.parseString(DataFormats.JSON.get().write(pack));
        return (ChunkGenerator)SpongeWorldTemplate.decodeStem(json, (RegistryAccess)SpongeCommon.server().registryAccess()).generator();
    }
}

