/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.world.schematic;

import java.util.Objects;
import java.util.Optional;
import java.util.function.BiFunction;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.spongepowered.api.registry.Registry;
import org.spongepowered.api.world.schematic.PaletteType;
import org.spongepowered.common.world.schematic.SpongePaletteType;

public class SpongePaletteTypeBuilder<T, R>
implements PaletteType.Builder<T, R> {
    private @MonotonicNonNull BiFunction<String, Registry<R>, Optional<T>> resolver;
    private @MonotonicNonNull BiFunction<Registry<R>, T, String> stringifier;

    @Override
    public PaletteType.Builder<T, R> reset() {
        this.resolver = null;
        this.stringifier = null;
        return this;
    }

    @Override
    public PaletteType.Builder<T, R> resolver(BiFunction<String, Registry<R>, Optional<T>> resolver) {
        this.resolver = Objects.requireNonNull(resolver, "Resolver cannot be null");
        return this;
    }

    @Override
    public PaletteType.Builder<T, R> stringifier(BiFunction<Registry<R>, T, String> stringifier) {
        this.stringifier = Objects.requireNonNull(stringifier, "Stringifier cannot be null");
        return this;
    }

    public PaletteType<T, R> build() throws IllegalStateException {
        Objects.requireNonNull(this.resolver, "Encoder cannot be null");
        Objects.requireNonNull(this.stringifier, "Decoder cannot be null");
        return new SpongePaletteType<T, R>(this.resolver, this.stringifier);
    }
}

