/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.world.volume.buffer.biome;

import java.util.Arrays;
import java.util.function.Function;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import net.minecraft.world.level.biome.Biome;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.world.volume.biome.BiomeVolume;
import org.spongepowered.api.world.volume.stream.StreamOptions;
import org.spongepowered.api.world.volume.stream.VolumeElement;
import org.spongepowered.api.world.volume.stream.VolumeStream;
import org.spongepowered.common.world.volume.SpongeVolumeStream;
import org.spongepowered.common.world.volume.VolumeStreamUtils;
import org.spongepowered.common.world.volume.buffer.biome.AbstractBiomeBuffer;
import org.spongepowered.math.vector.Vector3d;
import org.spongepowered.math.vector.Vector3i;

public final class ObjectArrayImmutableBiomeBuffer
extends AbstractBiomeBuffer
implements BiomeVolume.Immutable {
    private final org.spongepowered.api.world.biome.Biome[] biomes;

    public ObjectArrayImmutableBiomeBuffer(org.spongepowered.api.world.biome.Biome[] biomes, Vector3i start, Vector3i size) {
        super(start, size);
        this.biomes = (org.spongepowered.api.world.biome.Biome[])biomes.clone();
    }

    @Override
    public org.spongepowered.api.world.biome.Biome biome(int x, int y, int z) {
        this.checkRange(x, y, z);
        return this.biomes[this.getIndex(x, y, z)];
    }

    public Biome getNativeBiome(int x, int y, int z) {
        this.checkRange(x, y, z);
        org.spongepowered.api.world.biome.Biome type = this.biomes[this.getIndex(x, y, z)];
        return (Biome)type;
    }

    @Override
    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ObjectArrayImmutableBiomeBuffer that = (ObjectArrayImmutableBiomeBuffer)o;
        return Arrays.equals(this.biomes, that.biomes);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + Arrays.hashCode(this.biomes);
        return result;
    }

    @Override
    public VolumeStream<BiomeVolume.Immutable, org.spongepowered.api.world.biome.Biome> biomeStream(Vector3i min, Vector3i max, StreamOptions options) {
        VolumeStreamUtils.validateStreamArgs(min, max, options);
        Stream stateStream = IntStream.rangeClosed(this.min().x(), this.max().x()).mapToObj(x -> IntStream.rangeClosed(this.min().z(), this.max().z()).mapToObj(z -> IntStream.rangeClosed(this.min().y(), this.max().y()).mapToObj(y -> VolumeElement.of(this, () -> this.biomes[this.getIndex(x, y, z)], new Vector3d((float)x, (float)y, (float)z)))).flatMap(Function.identity())).flatMap(Function.identity());
        return new SpongeVolumeStream<BiomeVolume.Immutable, org.spongepowered.api.world.biome.Biome>(stateStream, () -> this);
    }
}

