/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.world.volume.buffer.block;

import java.util.Objects;
import java.util.function.Function;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.block.BlockType;
import org.spongepowered.api.block.BlockTypes;
import org.spongepowered.api.fluid.FluidState;
import org.spongepowered.api.registry.RegistryHolder;
import org.spongepowered.api.registry.RegistryReference;
import org.spongepowered.api.registry.RegistryTypes;
import org.spongepowered.api.world.schematic.Palette;
import org.spongepowered.api.world.schematic.PaletteTypes;
import org.spongepowered.api.world.volume.block.BlockVolume;
import org.spongepowered.api.world.volume.stream.StreamOptions;
import org.spongepowered.api.world.volume.stream.VolumeElement;
import org.spongepowered.api.world.volume.stream.VolumeStream;
import org.spongepowered.common.world.schematic.MutableBimapPalette;
import org.spongepowered.common.world.volume.SpongeVolumeStream;
import org.spongepowered.common.world.volume.VolumeStreamUtils;
import org.spongepowered.common.world.volume.buffer.block.AbstractBlockBuffer;
import org.spongepowered.common.world.volume.buffer.block.BlockBackingData;
import org.spongepowered.math.vector.Vector3d;
import org.spongepowered.math.vector.Vector3i;

public class ArrayMutableBlockBuffer
extends AbstractBlockBuffer
implements BlockVolume.Mutable {
    private static final BlockState AIR = (BlockState)BlockTypes.AIR.get().defaultState();
    private final Palette.Mutable<BlockState, BlockType> palette;
    private final RegistryReference<BlockType> defaultState;
    private BlockBackingData data;
    private final RegistryHolder registries;

    public ArrayMutableBlockBuffer(Vector3i start, Vector3i size) {
        this(new MutableBimapPalette<BlockState, BlockType>(PaletteTypes.BLOCK_STATE_PALETTE.get(), Sponge.game().registry(RegistryTypes.BLOCK_TYPE)), BlockTypes.AIR, start, size);
    }

    public ArrayMutableBlockBuffer(Palette<BlockState, BlockType> palette, RegistryReference<BlockType> defaultState, Vector3i start, Vector3i size) {
        super(start, size);
        Palette.Mutable<BlockState, BlockType> mutablePalette = palette.asMutable(Sponge.game());
        this.palette = mutablePalette;
        int airId = mutablePalette.orAssign(AIR);
        int dataSize = this.area();
        this.defaultState = defaultState;
        this.data = new BlockBackingData.PackedBackingData(dataSize, palette.highestId());
        if (airId != 0) {
            for (int i = 0; i < dataSize; ++i) {
                this.data.set(i, airId);
            }
        }
        this.registries = Sponge.game();
    }

    public ArrayMutableBlockBuffer(Palette<BlockState, BlockType> palette, Vector3i start, Vector3i size, char[] blocks) {
        super(start, size);
        this.palette = palette.asMutable(Sponge.game());
        this.data = new BlockBackingData.CharBackingData(blocks);
        this.defaultState = BlockTypes.AIR;
        this.registries = Sponge.game();
    }

    ArrayMutableBlockBuffer(Palette<BlockState, BlockType> palette, BlockBackingData blocks, Vector3i start, Vector3i size) {
        super(start, size);
        this.palette = palette.asMutable(Sponge.game());
        this.data = blocks;
        this.defaultState = BlockTypes.AIR;
        this.registries = Sponge.game();
    }

    @Override
    public Palette<BlockState, BlockType> getPalette() {
        return this.palette;
    }

    @Override
    public boolean setBlock(int x, int y, int z, BlockState block) {
        this.checkRange(x, y, z);
        int id = this.palette.orAssign(block);
        if (id > this.data.getMax()) {
            int highId = this.palette.highestId();
            int dataSize = this.area();
            BlockBackingData.PackedBackingData newdata = new BlockBackingData.PackedBackingData(dataSize, highId);
            for (int i = 0; i < dataSize; ++i) {
                newdata.set(i, this.data.get(i));
            }
            this.data = newdata;
        }
        this.data.set(this.getIndex(x, y, z), id);
        return true;
    }

    @Override
    public boolean removeBlock(int x, int y, int z) {
        this.checkRange(x, y, z);
        return this.setBlock(x, y, z, (BlockState)BlockTypes.AIR.get().defaultState());
    }

    @Override
    public BlockState block(int x, int y, int z) {
        this.checkRange(x, y, z);
        int id = this.data.get(this.getIndex(x, y, z));
        return this.palette.get(id, this.registries).orElseGet(() -> (BlockState)this.defaultState.get(this.registries).defaultState());
    }

    @Override
    public FluidState fluid(int x, int y, int z) {
        return this.block(x, y, z).fluidState();
    }

    @Override
    public int highestYAt(int x, int z) {
        return 0;
    }

    private int area() {
        return this.size.x() * this.size.y() * this.size.z();
    }

    @Override
    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ArrayMutableBlockBuffer that = (ArrayMutableBlockBuffer)o;
        return this.palette.equals(that.palette) && this.data.equals(that.data);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.palette, this.data);
    }

    @Override
    public VolumeStream<BlockVolume.Mutable, BlockState> blockStateStream(Vector3i min, Vector3i max, StreamOptions options) {
        VolumeStreamUtils.validateStreamArgs(min, max, this.min(), this.max(), options);
        ArrayMutableBlockBuffer buffer = options.carbonCopy() ? this.copy() : this;
        Stream stateStream = IntStream.rangeClosed(min.x(), max.x()).mapToObj(x -> IntStream.rangeClosed(min.z(), max.z()).mapToObj(z -> IntStream.rangeClosed(min.y(), max.y()).mapToObj(y -> VolumeElement.of(this, () -> buffer.block(x, y, z), new Vector3d((float)x, (float)y, (float)z)))).flatMap(Function.identity())).flatMap(Function.identity());
        return new SpongeVolumeStream<BlockVolume.Mutable, BlockState>(stateStream, () -> this);
    }

    public void setBlock(BlockPos pos, net.minecraft.world.level.block.state.BlockState blockState) {
        this.setBlock(pos.getX(), pos.getY(), pos.getZ(), (BlockState)blockState);
    }

    public net.minecraft.world.level.block.state.BlockState getBlock(BlockPos blockPos) {
        return (net.minecraft.world.level.block.state.BlockState)this.block(blockPos.getX(), blockPos.getY(), blockPos.getZ());
    }

    public ArrayMutableBlockBuffer copy() {
        return new ArrayMutableBlockBuffer(this.palette, this.data.copyOf(), this.start, this.size);
    }

    public BlockBackingData getCopiedBackingData() {
        return this.data.copyOf();
    }
}

