/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.vanilla.chat.console;

import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.ParseResults;
import com.mojang.brigadier.context.ParsedCommandNode;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import java.util.stream.IntStream;
import net.minecraft.commands.CommandSourceStack;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.jline.reader.Highlighter;
import org.jline.reader.LineReader;
import org.jline.utils.AttributedString;
import org.jline.utils.AttributedStringBuilder;
import org.jline.utils.AttributedStyle;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.command.brigadier.dispatcher.SpongeCommandDispatcher;

public class BrigadierHighlighter<S>
implements Highlighter {
    private static final AttributedStyle ERROR_STYLE = AttributedStyle.DEFAULT.foreground(1);
    private static final AttributedStyle LITERAL_STYLE = AttributedStyle.DEFAULT;
    private static final AttributedStyle[] ARGUMENT_STYLES = (AttributedStyle[])IntStream.of(6, 3, 2, 5, 4).mapToObj(arg_0 -> ((AttributedStyle)AttributedStyle.DEFAULT).foreground(arg_0)).toArray(AttributedStyle[]::new);
    private final Supplier<@Nullable SpongeCommandDispatcher> dispatcherProvider;
    private final Supplier<CommandSourceStack> commandSourceProvider;

    public BrigadierHighlighter(Supplier<@Nullable SpongeCommandDispatcher> dispatcherProvider, Supplier<CommandSourceStack> commandSourceProvider) {
        this.dispatcherProvider = dispatcherProvider;
        this.commandSourceProvider = commandSourceProvider;
    }

    public AttributedString highlight(LineReader lineReader, String buffer) {
        SpongeCommandDispatcher dispatcher = this.dispatcherProvider.get();
        if (dispatcher == null) {
            return new AttributedString((CharSequence)buffer);
        }
        try {
            ParseResults<CommandSourceStack> results = dispatcher.parse(buffer, this.commandSourceProvider.get(), true);
            ImmutableStringReader reader = results.getReader();
            AttributedStringBuilder builder = new AttributedStringBuilder();
            int lastPos = 0;
            int argColorIdx = 0;
            for (ParsedCommandNode node : results.getContext().getLastChild().getNodes()) {
                int start = Math.min(node.getRange().getStart(), reader.getTotalLength());
                int end = Math.min(node.getRange().getEnd(), reader.getTotalLength());
                if (lastPos < start) {
                    builder.append((CharSequence)reader.getString(), lastPos, start);
                }
                builder.append((CharSequence)reader.getString().substring(start, end), ARGUMENT_STYLES[argColorIdx]);
                argColorIdx = (argColorIdx + 1) % ARGUMENT_STYLES.length;
                lastPos = end;
            }
            if (lastPos < reader.getTotalLength()) {
                builder.append((CharSequence)reader.getString().substring(lastPos), results.getExceptions().isEmpty() ? LITERAL_STYLE : ERROR_STYLE);
            }
            return builder.toAttributedString();
        }
        catch (Exception ex) {
            SpongeCommon.logger().warn("Error while highlighting console command line", (Throwable)ex);
            return new AttributedString((CharSequence)buffer);
        }
    }

    public void setErrorPattern(Pattern errorPattern) {
    }

    public void setErrorIndex(int errorIndex) {
    }
}

