/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.vanilla.chat.console;

import com.mojang.brigadier.Message;
import com.mojang.brigadier.ParseResults;
import com.mojang.brigadier.suggestion.Suggestion;
import com.mojang.brigadier.suggestion.Suggestions;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.function.Supplier;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.ansi.ANSIComponentSerializer;
import net.kyori.adventure.translation.GlobalTranslator;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.network.chat.ComponentUtils;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.jline.reader.Candidate;
import org.jline.reader.Completer;
import org.jline.reader.LineReader;
import org.jline.reader.ParsedLine;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.adventure.SpongeAdventure;
import org.spongepowered.common.command.brigadier.dispatcher.SpongeCommandDispatcher;

final class BrigadierJLineCompleter<S>
implements Completer {
    private final Supplier<@Nullable SpongeCommandDispatcher> dispatcherProvider;
    private final Supplier<CommandSourceStack> commandSourceProvider;

    public BrigadierJLineCompleter(Supplier<@Nullable SpongeCommandDispatcher> dispatcherProvider, Supplier<CommandSourceStack> commandSourceProvider) {
        this.dispatcherProvider = dispatcherProvider;
        this.commandSourceProvider = commandSourceProvider;
    }

    public void complete(LineReader reader, ParsedLine line, List<Candidate> candidates) {
        SpongeCommandDispatcher dispatcher = this.dispatcherProvider.get();
        if (dispatcher == null) {
            return;
        }
        String input = line.line();
        ParseResults<CommandSourceStack> parseResult = dispatcher.parse(input, this.commandSourceProvider.get(), true);
        CompletableFuture<Suggestions> suggestions = dispatcher.getCompletionSuggestions(parseResult, line.cursor());
        try {
            Suggestions result = suggestions.get();
            for (Suggestion completion : result.getList()) {
                if (completion.getText().isEmpty()) continue;
                candidates.add(BrigadierJLineCompleter.candidateFromSuggestion(parseResult, completion));
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        catch (ExecutionException e) {
            SpongeCommon.logger().error("Failed to tab complete", (Throwable)e);
        }
    }

    private static Candidate candidateFromSuggestion(ParseResults<?> result, Suggestion suggestion) {
        Message tooltip = suggestion.getTooltip();
        Component componentTooltip = tooltip == null ? null : GlobalTranslator.render((Component)SpongeAdventure.asAdventure(ComponentUtils.fromMessage((Message)tooltip)), (Locale)Locale.getDefault());
        return new Candidate(suggestion.getText(), suggestion.getText(), null, (String)ANSIComponentSerializer.ansi().serializeOrNull(componentTooltip), null, null, result.getExceptions().isEmpty());
    }
}

