/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.vanilla.installer.model.mojang;

public record FormatVersion(int major, int minor) implements Comparable<FormatVersion>
{
    public static final String MANIFEST_ATTRIBUTE = "Bundler-Format";

    static FormatVersion parse(String attribute) {
        String[] split = attribute.split("\\.");
        if (split.length < 2) {
            throw new IllegalArgumentException("Invalid version " + attribute);
        }
        return new FormatVersion(Integer.parseInt(split[0]), Integer.parseInt(split[1]));
    }

    public boolean compatibleWith(FormatVersion other) {
        return other.major() == this.major() && other.minor() >= this.minor();
    }

    @Override
    public int compareTo(FormatVersion other) {
        if (this.major() != other.major()) {
            return Integer.compare(this.major(), other.major());
        }
        return Integer.compare(this.minor(), other.minor());
    }
}

