/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.vanilla.mixin.core.world.level.block.entity;

import java.util.Collections;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.AbstractCookingRecipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.AbstractFurnaceBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.block.entity.carrier.furnace.FurnaceBlockEntity;
import org.spongepowered.api.event.Cause;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.block.entity.CookingEvent;
import org.spongepowered.api.item.inventory.ItemStackSnapshot;
import org.spongepowered.api.item.recipe.cooking.CookingRecipe;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.bridge.block.entity.AbstractFurnaceBlockEntityBridge;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.item.util.ItemStackUtil;
import org.spongepowered.common.mixin.core.world.level.block.entity.BaseContainerBlockEntityMixin;
import org.spongepowered.vanilla.accessor.world.level.block.entity.AbstractFurnaceBlockEntityAccessor_Vanilla;

@Mixin(value={AbstractFurnaceBlockEntity.class})
public abstract class AbstractFurnaceBlockEntityMixin_Vanilla
extends BaseContainerBlockEntityMixin
implements AbstractFurnaceBlockEntityBridge {
    @Shadow
    protected NonNullList<ItemStack> items;
    @Shadow
    int cookingProgress;

    @Redirect(method={"serverTick"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/level/block/entity/AbstractFurnaceBlockEntity;canBurn(Lnet/minecraft/core/RegistryAccess;Lnet/minecraft/world/item/crafting/RecipeHolder;Lnet/minecraft/core/NonNullList;I)Z", ordinal=1))
    private static boolean vanillaImpl$checkIfCanSmelt(RegistryAccess registryAccess, @Nullable RecipeHolder<?> recipe, NonNullList<ItemStack> slots, int maxStackSize, Level level, BlockPos entityPos, BlockState state, AbstractFurnaceBlockEntity entity) {
        if (!AbstractFurnaceBlockEntityAccessor_Vanilla.invoker$canBurn(registryAccess, recipe, slots, maxStackSize)) {
            return false;
        }
        ItemStackSnapshot fuel = ItemStackUtil.snapshotOf((ItemStack)slots.get(1));
        Cause cause = PhaseTracker.getCauseStackManager().currentCause();
        if (((AbstractFurnaceBlockEntityMixin_Vanilla)entity).cookingProgress == 0) {
            CookingEvent.Start event = SpongeEventFactory.createCookingEventStart(cause, (FurnaceBlockEntity)entity, Optional.of(fuel), Optional.of((CookingRecipe)recipe.value()), Optional.of((ResourceKey)recipe.id()));
            SpongeCommon.post(event);
            return !event.isCancelled();
        }
        ItemStackSnapshot cooking = ItemStackUtil.snapshotOf((ItemStack)((AbstractFurnaceBlockEntityMixin_Vanilla)entity).items.get(0));
        CookingEvent.Tick event = SpongeEventFactory.createCookingEventTick(cause, (FurnaceBlockEntity)entity, cooking, Optional.of(fuel), Optional.of((CookingRecipe)recipe.value()), Optional.of((ResourceKey)recipe.id()));
        SpongeCommon.post(event);
        return !event.isCancelled();
    }

    @Redirect(method={"serverTick"}, at=@At(value="INVOKE", target="Lnet/minecraft/util/Mth;clamp(III)I"))
    private static int vanillaImpl$resetCookTimeIfCancelled(int newCookTime, int zero, int totalCookTime, Level level, BlockPos entityPos, BlockState state, AbstractFurnaceBlockEntity entity) {
        int clampedCookTime = Mth.clamp((int)newCookTime, (int)zero, (int)totalCookTime);
        ItemStackSnapshot fuel = ItemStackUtil.snapshotOf((ItemStack)((AbstractFurnaceBlockEntityMixin_Vanilla)entity).items.get(1));
        Cause cause = PhaseTracker.getCauseStackManager().currentCause();
        Optional<? extends RecipeHolder<? extends AbstractCookingRecipe>> recipe = ((AbstractFurnaceBlockEntityMixin_Vanilla)entity).bridge$getCurrentRecipe();
        ItemStackSnapshot cooking = ItemStackUtil.snapshotOf((ItemStack)((AbstractFurnaceBlockEntityMixin_Vanilla)entity).items.get(0));
        CookingEvent.Tick event = SpongeEventFactory.createCookingEventTick(cause, (FurnaceBlockEntity)entity, cooking, Optional.of(fuel), recipe.map(r -> (CookingRecipe)r.value()), recipe.map(r -> (ResourceKey)r.id()));
        SpongeCommon.post(event);
        if (event.isCancelled()) {
            return ((AbstractFurnaceBlockEntityMixin_Vanilla)entity).cookingProgress;
        }
        return clampedCookTime;
    }

    @Inject(method={"burn"}, locals=LocalCapture.CAPTURE_FAILHARD, at={@At(value="INVOKE", target="Lnet/minecraft/world/item/ItemStack;shrink(I)V")})
    private static void vanillaImpl$afterSmeltItem(RegistryAccess registryAccess, RecipeHolder<?> recipe, NonNullList<ItemStack> slots, int var2, CallbackInfoReturnable<Boolean> cir) {
        ItemStackSnapshot fuel = ItemStackUtil.snapshotOf((ItemStack)slots.get(1));
        Cause cause = PhaseTracker.getCauseStackManager().currentCause();
        FurnaceBlockEntity entity = cause.first(FurnaceBlockEntity.class).orElseThrow(() -> new IllegalStateException("Expected to have a FurnaceBlockEntity in the Cause"));
        ItemStackSnapshot snapshot = ItemStackUtil.snapshotOf(recipe.value().getResultItem(registryAccess));
        CookingEvent.Finish event = SpongeEventFactory.createCookingEventFinish(cause, entity, Collections.singletonList(snapshot), Optional.of(fuel), Optional.ofNullable((CookingRecipe)recipe.value()), Optional.of((ResourceKey)recipe.id()));
        SpongeCommon.post(event);
    }
}

