/*
 * Decompiled with CFR 0.152.
 */
package org.tinylog.converters;

import java.io.File;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.tinylog.converters.FileConverter;
import org.tinylog.converters.GzipEncoder;
import org.tinylog.converters.NamedDaemonThreadFactory;

public final class GzipFileConverter
implements FileConverter {
    private static final AtomicInteger count = new AtomicInteger();
    private final ExecutorService executor = Executors.newSingleThreadExecutor(new NamedDaemonThreadFactory("tinylog-GZipThread-" + count.getAndIncrement()));
    private volatile File file;

    @Override
    public String getBackupSuffix() {
        return ".gz";
    }

    @Override
    public void open(String fileName) {
        this.file = new File(fileName);
    }

    @Override
    public byte[] write(byte[] data) {
        return data;
    }

    @Override
    public void close() {
        this.executor.execute(new GzipEncoder(this.file));
    }

    @Override
    public void shutdown() throws InterruptedException {
        this.executor.shutdown();
        this.executor.awaitTermination(1L, TimeUnit.MINUTES);
    }
}

