/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.event;

import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.StringJoiner;
import java.util.function.Supplier;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.event.EventContextKey;
import org.spongepowered.api.util.CopyableBuilder;
import org.spongepowered.api.util.annotation.DoNotStore;

@DoNotStore
public final class EventContext {
    private static final EventContext EMPTY_CONTEXT = new EventContext(Map.of());
    private final Map<EventContextKey<?>, Object> entries;

    public static EventContext empty() {
        return EMPTY_CONTEXT;
    }

    public static EventContext of(Map<EventContextKey<?>, Object> entries) {
        Objects.requireNonNull(entries, "Context entries cannot be null");
        for (Map.Entry<EventContextKey<?>, Object> entry : entries.entrySet()) {
            Objects.requireNonNull(entry.getValue(), "Entries cannot contain null values");
        }
        return new EventContext(entries);
    }

    public static Builder builder() {
        return new Builder();
    }

    EventContext(Map<EventContextKey<?>, Object> values) {
        this.entries = Map.copyOf(values);
    }

    public <T> Optional<T> get(EventContextKey<T> key) {
        Objects.requireNonNull(key, "EventContextKey cannot be null");
        return Optional.ofNullable(this.entries.get(key));
    }

    public <T> Optional<T> get(Supplier<EventContextKey<T>> key) {
        Objects.requireNonNull(key, "EventContextKey cannot be null");
        return Optional.ofNullable(this.entries.get(key.get()));
    }

    public <T> T require(EventContextKey<T> key) {
        Optional<T> optional = this.get(key);
        if (optional.isPresent()) {
            return optional.get();
        }
        throw new NoSuchElementException(String.format("Could not retrieve value for key '%s'", key.toString()));
    }

    public <T> T require(Supplier<EventContextKey<T>> key) {
        Optional<T> optional = this.get(key);
        if (optional.isPresent()) {
            return optional.get();
        }
        throw new NoSuchElementException(String.format("Could not retrieve value for key '%s'", key.get().toString()));
    }

    public boolean containsKey(EventContextKey<?> key) {
        return this.entries.containsKey(key);
    }

    public boolean containsKey(Supplier<? extends EventContextKey<?>> key) {
        return this.entries.containsKey(key.get());
    }

    public Set<EventContextKey<?>> keySet() {
        return this.entries.keySet();
    }

    public Map<EventContextKey<?>, Object> asMap() {
        return this.entries;
    }

    public boolean equals(@Nullable Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof EventContext)) {
            return false;
        }
        EventContext ctx = (EventContext)object;
        for (Map.Entry<EventContextKey<?>, Object> entry : this.entries.entrySet()) {
            Object other = ctx.entries.get(entry.getKey());
            if (other == null) {
                return false;
            }
            if (entry.getValue().equals(other)) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return this.entries.hashCode();
    }

    public String toString() {
        StringJoiner joiner = new StringJoiner(", ");
        for (Map.Entry<EventContextKey<?>, Object> entry : this.entries.entrySet()) {
            joiner.add("\"" + entry.getKey().toString() + "\"=" + entry.getValue().toString());
        }
        return "Context[" + joiner.toString() + "]";
    }

    public static final class Builder
    implements org.spongepowered.api.util.Builder<EventContext, Builder>,
    CopyableBuilder<EventContext, Builder> {
        private final Map<EventContextKey<?>, Object> entries = new HashMap();

        Builder() {
        }

        public <T> Builder add(EventContextKey<T> key, T value) {
            Objects.requireNonNull(value, "Context object cannot be null");
            if (this.entries.containsKey(key)) {
                throw new IllegalArgumentException("Duplicate context keys: " + key.toString());
            }
            this.entries.put(key, value);
            return this;
        }

        public <T> Builder add(Supplier<EventContextKey<T>> key, T value) {
            Objects.requireNonNull(value, "Context object cannot be null");
            EventContextKey<T> suppliedKey = key.get();
            Objects.requireNonNull(suppliedKey, "Supplied key cannot be null!");
            if (this.entries.containsKey(suppliedKey)) {
                throw new IllegalArgumentException("Duplicate context keys!");
            }
            this.entries.put(suppliedKey, value);
            return this;
        }

        @Override
        public Builder from(EventContext value) {
            this.entries.putAll(value.entries);
            return this;
        }

        @Override
        public Builder reset() {
            this.entries.clear();
            return this;
        }

        public EventContext build() {
            return new EventContext(this.entries);
        }
    }
}

