/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.util;

import java.util.Objects;
import java.util.StringJoiner;
import org.checkerframework.checker.nullness.qual.Nullable;

public class Tuple<K, V> {
    private final K first;
    private final V second;

    public static <K, V> Tuple<K, V> of(K first, V second) {
        return new Tuple<K, V>(first, second);
    }

    public Tuple(K first, V second) {
        this.first = Objects.requireNonNull(first);
        this.second = Objects.requireNonNull(second);
    }

    public K first() {
        return this.first;
    }

    public V second() {
        return this.second;
    }

    public String toString() {
        return new StringJoiner(", ", Tuple.class.getSimpleName() + "[", "]").add("first=" + String.valueOf(this.first)).add("second=" + String.valueOf(this.second)).toString();
    }

    public int hashCode() {
        return Objects.hash(this.first, this.second);
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Tuple other = (Tuple)obj;
        return Objects.equals(this.first, other.first) && Objects.equals(this.second, other.second);
    }
}

