/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.world.volume.stream;

import java.lang.ref.WeakReference;
import java.util.Objects;
import java.util.StringJoiner;
import java.util.function.Supplier;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.world.volume.Volume;
import org.spongepowered.math.vector.Vector3d;

public interface VolumeElement<V extends Volume, T> {
    public static <W extends Volume, T> VolumeElement<W, T> of(final Supplier<W> volume, final Supplier<? extends T> type, final Vector3d position) {
        return new VolumeElement<W, T>(){

            @Override
            public W volume() {
                return (Volume)volume.get();
            }

            @Override
            public Vector3d position() {
                return position;
            }

            @Override
            public T type() {
                return type.get();
            }

            public String toString() {
                return new StringJoiner(", ", VolumeElement.class.getSimpleName() + "[", "]").add("reference=" + String.valueOf(volume.get())).add("type=" + String.valueOf(type.get())).add("position=" + String.valueOf(position)).toString();
            }

            /*
             * Issues handling annotations - annotations may be inaccurate
             */
            public boolean equals(@Nullable Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                @NonNull VolumeElement that = (VolumeElement)o;
                return ((Volume)volume.get()).equals(that.volume()) && type.get().equals(that.type()) && position.equals((Object)that.position());
            }

            public int hashCode() {
                return Objects.hash(volume.get(), type.get(), position);
            }
        };
    }

    public static <V extends Volume, T> VolumeElement<V, T> of(V volume, Supplier<? extends T> type, Vector3d position) {
        WeakReference volumeRef = new WeakReference(volume);
        Supplier<Volume> volumeSupplier = () -> Objects.requireNonNull((Volume)volumeRef.get(), "Volume de-referenced");
        return VolumeElement.of(volumeSupplier, type, position);
    }

    public static <V extends Volume, T> VolumeElement<V, T> of(V volume, T type, Vector3d position) {
        WeakReference volumeRef = new WeakReference(volume);
        Supplier<Volume> volumeSupplier = () -> Objects.requireNonNull((Volume)volumeRef.get(), "Volume de-referenced");
        WeakReference typeRef = new WeakReference(type);
        Supplier<Object> typeSupplier = () -> Objects.requireNonNull(typeRef.get(), "Element instance de-referenced");
        return VolumeElement.of(volumeSupplier, typeSupplier, position);
    }

    public V volume();

    public Vector3d position();

    public T type();
}

