/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.advancement;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import java.io.IOException;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.critereon.CriterionValidator;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.spongepowered.api.advancement.criteria.trigger.FilteredTrigger;
import org.spongepowered.api.advancement.criteria.trigger.FilteredTriggerConfiguration;
import org.spongepowered.api.data.persistence.DataContainer;
import org.spongepowered.api.data.persistence.DataFormats;
import org.spongepowered.api.data.persistence.DataSerializable;

public final class SpongeFilteredTrigger
implements CriterionTriggerInstance,
FilteredTrigger {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Gson GSON = new Gson();
    private final FilteredTriggerConfiguration configuration;

    SpongeFilteredTrigger(FilteredTriggerConfiguration configuration) {
        this.configuration = configuration;
    }

    public FilteredTriggerConfiguration configuration() {
        return this.configuration;
    }

    public JsonObject serializeToJson() {
        if (this.configuration instanceof DataSerializable) {
            DataContainer dataContainer = ((DataSerializable)((Object)this.configuration)).toContainer();
            try {
                String json = DataFormats.JSON.get().write(dataContainer);
                return GSON.fromJson(json, JsonObject.class);
            }
            catch (IOException e) {
                LOGGER.error("Failed to serialize trigger to json", (Throwable)e);
            }
        }
        return GSON.toJsonTree(this.configuration).getAsJsonObject();
    }

    public void validate(CriterionValidator var1) {
    }
}

