/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.advancement.criterion;

import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.advancement.AdvancementProgress;
import org.spongepowered.api.advancement.criteria.AdvancementCriterion;
import org.spongepowered.api.advancement.criteria.CriterionProgress;
import org.spongepowered.common.advancement.criterion.ImplementationBackedCriterionProgress;
import org.spongepowered.common.advancement.criterion.SpongeOperatorCriterion;

public abstract class SpongeOperatorCriterionProgress
implements ImplementationBackedCriterionProgress,
CriterionProgress {
    final AdvancementProgress progress;
    private final SpongeOperatorCriterion criterion;
    private @Nullable Optional<Instant> cachedAchievedState;

    SpongeOperatorCriterionProgress(AdvancementProgress progress, SpongeOperatorCriterion criterion) {
        this.progress = progress;
        this.criterion = criterion;
    }

    @Override
    public SpongeOperatorCriterion criterion() {
        return this.criterion;
    }

    @Override
    public Optional<Instant> get() {
        if (this.cachedAchievedState == null) {
            this.cachedAchievedState = this.get0();
        }
        return this.cachedAchievedState;
    }

    abstract Optional<Instant> get0();

    @Override
    public Instant grant() {
        Instant time = null;
        for (AdvancementCriterion criterion : this.criterion.criteria()) {
            Instant time1 = this.progress.get(criterion).get().grant();
            if (time != null && !time1.isAfter(time)) continue;
            time = time1;
        }
        Objects.requireNonNull(time);
        return time;
    }

    @Override
    public Optional<Instant> revoke() {
        Optional<Instant> previousState = this.get();
        for (AdvancementCriterion criterion : this.criterion.criteria()) {
            this.progress.get(criterion).get().revoke();
        }
        return previousState;
    }

    @Override
    public void invalidateAchievedState() {
        this.cachedAchievedState = null;
    }
}

