/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.applaunch.config.core;

import java.lang.reflect.Type;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Objects;
import java.util.function.Predicate;
import org.spongepowered.configurate.serialize.ScalarSerializer;
import org.spongepowered.configurate.serialize.SerializationException;

public final class IpSet
implements Predicate<InetAddress> {
    private final InetAddress addr;
    private final int prefixLen;

    IpSet(InetAddress addr, int prefixLen) {
        this.addr = addr;
        this.prefixLen = prefixLen;
    }

    @Override
    public boolean test(InetAddress input) {
        byte i;
        byte[] checkAddr;
        byte[] address = input.getAddress();
        if (address.length != (checkAddr = this.addr.getAddress()).length) {
            return false;
        }
        byte completeSegments = (byte)(this.prefixLen >> 3);
        byte overlap = (byte)(this.prefixLen & 7);
        for (i = 0; i < completeSegments; i = (byte)(i + 1)) {
            if (address[i] == checkAddr[i]) continue;
            return false;
        }
        for (i = 0; i < overlap; i = (byte)(i + 1)) {
            if ((checkAddr[completeSegments + 1] >> 7 - i & 1) == (address[completeSegments + 1] >> 7 - i & 1)) continue;
            return false;
        }
        return true;
    }

    public static IpSet fromAddrPrefix(InetAddress address, int prefixLen) {
        IpSet.validatePrefixLength(Objects.requireNonNull(address, "address"), prefixLen);
        return new IpSet(address, prefixLen);
    }

    public static IpSet fromCidr(String spec) {
        InetAddress addr;
        String addrString;
        int prefixLen;
        int slashIndex = Objects.requireNonNull(spec, "spec").lastIndexOf("/");
        if (slashIndex == -1) {
            prefixLen = 32;
            addrString = spec;
        } else {
            prefixLen = Integer.parseInt(spec.substring(slashIndex + 1));
            addrString = spec.substring(0, slashIndex);
        }
        try {
            addr = InetAddress.getByName(addrString);
        }
        catch (UnknownHostException e) {
            throw new IllegalArgumentException(addrString + " does not contain a valid IP address");
        }
        return IpSet.fromAddrPrefix(addr, prefixLen);
    }

    private static void validatePrefixLength(InetAddress address, int prefixLen) throws IllegalArgumentException {
        if (prefixLen < 0) {
            throw new IllegalArgumentException("Minimum prefix length for an IP address is 0!");
        }
        int maxLen = IpSet.getMaxPrefixLength(address);
        if (prefixLen > maxLen) {
            throw new IllegalArgumentException("Maximum prefix length for a " + address.getClass().getSimpleName() + " is " + maxLen);
        }
    }

    private static int getMaxPrefixLength(InetAddress address) {
        if (address instanceof Inet4Address) {
            return 32;
        }
        if (address instanceof Inet6Address) {
            return 128;
        }
        throw new IllegalArgumentException("Unknown IP address type " + String.valueOf(address));
    }

    public String toString() {
        return this.addr.getHostAddress() + "/" + this.prefixLen;
    }

    public static final class Serializer
    extends ScalarSerializer<IpSet> {
        public static final Serializer INSTANCE = new Serializer();

        private Serializer() {
            super(IpSet.class);
        }

        @Override
        public IpSet deserialize(Type type, Object value) throws SerializationException {
            try {
                return IpSet.fromCidr(value.toString());
            }
            catch (IllegalArgumentException e) {
                throw new SerializationException(e);
            }
        }

        @Override
        public Object serialize(IpSet item, Predicate<Class<?>> typeSupported) {
            return item.toString();
        }
    }
}

