/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.command.parameter.managed.builder;

import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.function.Supplier;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.spongepowered.api.command.parameter.managed.ValueParameter;
import org.spongepowered.api.command.parameter.managed.standard.VariableValueParameters;
import org.spongepowered.common.command.parameter.managed.standard.SpongeChoicesValueParameter;
import org.spongepowered.common.util.Preconditions;

public final class SpongeStaticChoicesBuilder<T>
implements VariableValueParameters.StaticChoicesBuilder<T> {
    private final HashMap<String, Supplier<? extends T>> choices = new HashMap();
    private boolean showInUsage = false;

    @Override
    public  @NonNull VariableValueParameters.StaticChoicesBuilder<T> addChoices(@NonNull Iterable<String> choices, @NonNull Supplier<? extends T> returnedObjectSupplier) {
        for (String string : choices) {
            this.choices.put(string, returnedObjectSupplier);
        }
        return this;
    }

    @Override
    public  @NonNull VariableValueParameters.StaticChoicesBuilder<T> showInUsage(boolean showInUsage) {
        this.showInUsage = showInUsage;
        return this;
    }

    @Override
    public @NonNull ValueParameter<T> build() {
        Preconditions.checkState(!this.choices.isEmpty(), "There must be at least one choice!");
        ImmutableMap immutableChoices = ImmutableMap.copyOf(this.choices);
        return new SpongeChoicesValueParameter(immutableChoices, this.showInUsage, false);
    }

    @Override
    public  @NonNull VariableValueParameters.StaticChoicesBuilder<T> reset() {
        this.choices.clear();
        this.showInUsage = false;
        return this;
    }
}

