/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data;

import io.leangen.geantyref.GenericTypeReflector;
import java.lang.reflect.Array;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.data.persistence.DataQuery;
import org.spongepowered.api.data.persistence.DataSerializable;
import org.spongepowered.api.data.persistence.DataView;
import org.spongepowered.api.registry.Registry;
import org.spongepowered.common.data.SpongeDataManager;
import org.spongepowered.configurate.util.Types;

public class DataDeserializer {
    public static <T> BiFunction<DataView, DataQuery, Optional<T>> deserializer(Type elementType) {
        Class<?> rawType = GenericTypeReflector.erase(elementType);
        if (DataView.class.isAssignableFrom(rawType)) {
            return (view, dataQuery) -> view.getView((DataQuery)dataQuery);
        }
        if (DataSerializable.class.isAssignableFrom(rawType)) {
            return (view, dataQuery) -> view.getSerializable((DataQuery)dataQuery, rawType);
        }
        Optional registryTypeForValue = SpongeDataManager.INSTANCE.findRegistryTypeFor(rawType);
        if (registryTypeForValue.isPresent()) {
            return (view, dataQuery) -> registryTypeForValue.flatMap(regType -> view.getRegistryValue((DataQuery)dataQuery, regType));
        }
        if (SpongeDataManager.INSTANCE.translator(rawType).isPresent()) {
            return (view, dataQuery) -> view.getObject((DataQuery)dataQuery, rawType);
        }
        if (ResourceKey.class.isAssignableFrom(rawType)) {
            return (view, dataQuery) -> view.getString((DataQuery)dataQuery).map(ResourceKey::resolve);
        }
        if (Set.class.isAssignableFrom(rawType)) {
            Type listType = ((ParameterizedType)elementType).getActualTypeArguments()[0];
            return (view, dataQuery) -> DataDeserializer.deserializeList((Class)listType, view, dataQuery).map(list -> new HashSet(list));
        }
        if (List.class.isAssignableFrom(rawType)) {
            Type listType = ((ParameterizedType)elementType).getActualTypeArguments()[0];
            return (view, dataQuery) -> DataDeserializer.deserializeList((Class)listType, view, dataQuery);
        }
        if (Collection.class.isAssignableFrom(rawType)) {
            throw new UnsupportedOperationException("Collection deserialization is not supported. Provide the deserializer for it.");
        }
        if (Types.isArray(elementType)) {
            Class<?> arrayType = GenericTypeReflector.erase(GenericTypeReflector.getArrayComponentType(elementType));
            return (view, dataQuery) -> DataDeserializer.deserializeList(arrayType, view, dataQuery).map(list -> DataDeserializer.listToArray(arrayType, list));
        }
        if (Map.class.isAssignableFrom(rawType)) {
            Type[] parameterTypes = ((ParameterizedType)elementType).getActualTypeArguments();
            Type keyType = parameterTypes[0];
            Type valueType = parameterTypes[1];
            if (!(keyType instanceof Class)) {
                throw new UnsupportedOperationException("Unsupported map-key type " + String.valueOf(keyType));
            }
            Function<DataQuery, ?> keyDeserializer = DataDeserializer.mapKeyDeserializer(keyType);
            BiFunction valueDeserializer = DataDeserializer.deserializer(valueType);
            return (view, dataQuery) -> DataDeserializer.deserializeMap(view, dataQuery, keyDeserializer, valueDeserializer);
        }
        return (view, dataQuery) -> view.get((DataQuery)dataQuery);
    }

    private static Function<DataQuery, ?> mapKeyDeserializer(Type keyType) {
        Optional registryTypeForKey = SpongeDataManager.INSTANCE.findRegistryTypeFor((Class)keyType);
        if (registryTypeForKey.isPresent()) {
            Registry registry = Sponge.game().findRegistry(registryTypeForKey.get()).get();
            return key -> registry.value(ResourceKey.resolve(key.toString()));
        }
        if (((Class)keyType).isEnum()) {
            return key -> Enum.valueOf((Class)keyType, key.toString());
        }
        if (keyType == String.class) {
            return DataQuery::toString;
        }
        if (keyType == UUID.class) {
            return key -> UUID.fromString(key.toString());
        }
        if (keyType == ResourceKey.class) {
            return key -> ResourceKey.resolve(key.toString());
        }
        if (keyType == Integer.class) {
            return key -> Integer.valueOf(key.toString());
        }
        throw new UnsupportedOperationException("Unsupported map-key type " + String.valueOf(keyType));
    }

    private static Optional<?> deserializeMap(DataView view, DataQuery dataQuery, Function<DataQuery, ?> keyDeserializer, BiFunction<DataView, DataQuery, Optional<Object>> valueDeserializer) {
        return view.getView(dataQuery).map(mapView -> {
            HashMap resultMap = new HashMap();
            for (DataQuery key : mapView.keys(false)) {
                Object mapKey = keyDeserializer.apply(key);
                Optional mapValue = (Optional)valueDeserializer.apply((DataView)mapView, key);
                resultMap.put(mapKey, mapValue.get());
            }
            return resultMap;
        });
    }

    private static <T> Optional<List<T>> deserializeList(Class<T> listType, DataView view, DataQuery dataQuery) {
        if (DataView.class.isAssignableFrom(listType)) {
            return view.getViewList(dataQuery);
        }
        if (DataSerializable.class.isAssignableFrom(listType)) {
            return view.getSerializableList(dataQuery, listType);
        }
        Optional registryTypeFor = SpongeDataManager.INSTANCE.findRegistryTypeFor(listType);
        if (registryTypeFor.isPresent()) {
            return view.getRegistryValueList(dataQuery, registryTypeFor.get());
        }
        if (SpongeDataManager.INSTANCE.translator(listType).isPresent()) {
            return view.getObjectList(dataQuery, listType);
        }
        return view.getList(dataQuery);
    }

    private static <AT> AT[] listToArray(Class<AT> componentType, List<AT> list) {
        return list.toArray((Object[])Array.newInstance(componentType, list.size()));
    }
}

