/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.persistence.datastore;

import com.google.common.collect.ImmutableList;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.data.Key;
import org.spongepowered.api.data.persistence.DataContentUpdater;
import org.spongepowered.api.data.persistence.DataView;
import org.spongepowered.api.util.Tuple;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.data.DataUpdaterDelegate;
import org.spongepowered.common.data.persistence.datastore.VanillaDataStore;

public final class SpongeDataStore
extends VanillaDataStore {
    private ResourceKey key;
    private int version;
    private DataContentUpdater[] updaters;

    public SpongeDataStore(ResourceKey key, Map<Key<?>, Tuple<BiConsumer<DataView, ?>, Function<DataView, Optional<?>>>> queriesByKey, Collection<Type> tokens, int version, DataContentUpdater[] updaters) {
        super(queriesByKey, tokens);
        this.key = key;
        this.version = version;
        this.updaters = updaters;
    }

    public ResourceKey getDataStoreKey() {
        return this.key;
    }

    public int getVersion() {
        return this.version;
    }

    public Optional<DataContentUpdater> getUpdaterFor(Integer fromVersion) {
        int toVersion = this.version;
        ImmutableList.Builder builder = ImmutableList.builder();
        int version = fromVersion;
        for (DataContentUpdater updater : this.updaters) {
            if (updater.inputVersion() != version || updater.outputVersion() > toVersion) continue;
            version = updater.outputVersion();
            builder.add((Object)updater);
        }
        if (version < toVersion || version > toVersion) {
            String message = "Failed to update content for datastore: " + this.key.asString() + "\nUpdating from " + fromVersion + " to " + toVersion + " is impossible.\nPlease notify the plugin author of this error.";
            SpongeCommon.logger().warn(message);
            return Optional.empty();
        }
        ImmutableList updatersList = builder.build();
        if (updatersList.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(new DataUpdaterDelegate((ImmutableList<DataContentUpdater>)updatersList, fromVersion, toVersion));
    }
}

